/***********************************************************************
 * Copyright (c) 2009 CA, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CA, Inc. - Initial implementation
 ***********************************************************************/
package org.eclipse.cosmos.me.sdd.cr.impl;

import java.text.MessageFormat;

import javax.xml.namespace.QName;

import org.eclipse.cosmos.me.sdd.cr.Constraint;
import org.eclipse.cosmos.me.sdd.cr.ResolverByQname;
import org.eclipse.cosmos.me.sdd.cr.IResolver;
import org.eclipse.cosmos.me.sdd.schema.ext.ResolutionObject;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

public class ResolverByQnameImpl implements ResolverByQname {
	static final String QUERY = "("+IResolver.QNAME+"={0})";
	private BundleContext context;
	
	protected void activate(ComponentContext ctxt) {
		context = ctxt.getBundleContext();
	}
	
	protected void deactivate(ComponentContext ctxt) {
		context = null;
	}
	
	public ResolutionObject resolve(String qname, Constraint c) {
		ResolutionObject result = null;
		ServiceReference ref = lookup(qname);
		if (ref != null) {
			IResolver r = (IResolver) context.getService(ref);
			if (r != null) {
				result = r.resolve(c);
			}
			context.ungetService(ref);
		}
		return result;
	}
	
	public ResolutionObject resolve(QName qname, Constraint c) {
		return resolve(qname.toString(), c);
	}

	private ServiceReference lookup(String qname) {
		ServiceReference ref = null;
		String query = MessageFormat.format(QUERY, qname);
		try {
			ServiceReference[] refs = context.getServiceReferences(IResolver.class.getName(), query);
			if (refs != null && refs.length > 0) {
				ref = refs[0];
			}
		} catch (InvalidSyntaxException e) {
			return null;
		}
		
		return ref;
	}
}
