/***********************************************************************
 * Copyright (c) 2009 CA, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CA, Inc. - Initial implementation
 ***********************************************************************/
package org.eclipse.cosmos.me.sdd.cim.profile;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

import org.eclipse.cosmos.me.sdd.op.IOperationHandler;
import org.eclipse.cosmos.me.sdd.op.listener.event.InstallationProgress;
import org.eclipse.cosmos.me.sdd.schema.AdditionalContentType;
import org.eclipse.cosmos.me.sdd.schema.ArgumentType;
import org.eclipse.cosmos.me.sdd.schema.ArtifactType;
import org.eclipse.cosmos.me.sdd.schema.ContentType;
import org.eclipse.cosmos.me.sdd.schema.OperationType;
import org.eclipse.cosmos.me.sdd.schema.ext.SDDContext;

public class OpHandlerZip implements IOperationHandler {
	private InstallationProgress progress;
	
	public void setProgress(InstallationProgress progress) {
		this.progress = progress;
	}
	
	public void unsetProgress(InstallationProgress progress) {
		this.progress = null;
	}
	
	public void invokeAction(SDDContext ctxt, ArtifactType artifact, OperationType operation) {
		progress.progressBeginningAction(this.getClass().getSimpleName() + "::invokeAction");
		if (ctxt == null || artifact == null) {
			progress.progressFailedAction(this.getClass().getSimpleName() + "::invokeAction", null);
			return;
		}
		switch (operation) {
		case INSTALL:
		{
			String srcPath = null;
			// get source
			if (artifact.getContentRef() != null) {
				ContentType content = ctxt.getContentById(artifact.getContentRef());
				if (content != null) {
					srcPath = content.getPathname();
				}
			}
			
			if (srcPath != null) {
				// first argument is assumed to be destination
				List<ArgumentType> arguments = artifact.getArguments().getArgument();
				if (!arguments.isEmpty()) {
					ArgumentType at = arguments.get(0);
					String dest = ctxt.substituteVariables(at.getValue());
					InputStream stream = ctxt.getInputStreamForPath(srcPath);
					unzip(stream, dest);
				}
			}
		} break;
		default:
			System.out.printf("%s::invokeAction\n", this.getClass().getName());
		}
		progress.progressCompleteAction(this.getClass().getSimpleName() + "::invokeAction");
	}
	
	public void invokeAction(SDDContext ctxt, ArtifactType artifact, AdditionalContentType content,
			OperationType operation) {
	}

	private void unzip(InputStream stream, String path) {
		final int BUFFER = 2048;
		try {
			ZipInputStream zis = new ZipInputStream(new BufferedInputStream(stream));
			ZipEntry entry;
			while ((entry = zis.getNextEntry()) != null) {
				// write the files to the disk
				String destPath = path + File.separator + entry.getName();
				File destDir = new File(destPath);
				if( entry.isDirectory() && !destDir.exists() )
				{
					// it's a directory, create & continue
					destDir.mkdirs();
					continue;
				}

				FileOutputStream fos = new FileOutputStream(destDir);
				BufferedOutputStream dest = new BufferedOutputStream(fos, BUFFER);
				
				int count;
				byte data[] = new byte[BUFFER];
				while ((count = zis.read(data, 0, BUFFER)) != -1) {
					dest.write(data, 0, count);
				}
				dest.flush();
				dest.close();
			}
			zis.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
