/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.DeploymentDescriptorImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.FixIdentityImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.IdentityImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.MaintenanceInformationImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.ManufacturerInformationImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.PackageContentImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.PackageDescriptorImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.PackageIdentityImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.ReferencedPackageImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.ResourceImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.ResourceMapImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.ResultingChangeMapImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.ResultingResourceMapImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.util.ConversionUtil;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.BaseFactory;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.DeploymentDescriptor;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.FixIdentity;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Identity;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.MaintenanceInformation;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ManufacturerInformation;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.PackageContent;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.PackageDescriptor;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.PackageIdentity;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ReferencedPackage;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Resource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ResourceMap;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ResultingChangeMap;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ResultingResourceMap;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ContentUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseFactoryImpl
extends SPIObject
implements BaseFactory {
    public BaseFactoryImpl(SPISessionImpl sessionImpl) {
        super(sessionImpl);
    }

    @Override
    public DeploymentDescriptor createDeploymentDescriptor(String schemaVersion, byte[] descriptorID, Date lastModified, ContentUnit content, Collection<Resource> resources) {
        this.log.entering(this.getClass().getName(), "createDeploymentDescriptor");
        this.session.testParameter(schemaVersion, 1, null);
        this.session.testParameter(descriptorID, 2, null);
        this.session.testParameter(lastModified, 3, null);
        this.session.testParameter(content, 4, null);
        this.session.testParameter(resources, 5, null);
        Document ddDocument = this.session.getDocumentBuilder().newDocument();
        Element ddRoot = this.session.createDeploymentElement("DeploymentDescriptor");
        ddRoot.setAttribute("xmlns:sdd-common", "http://docs.oasis-open.org/sdd/ns/common");
        ddRoot.setAttribute("schemaVersion", schemaVersion);
        if (descriptorID != null && descriptorID.length != 16) {
            throw new InvalidInputException(2, 4);
        }
        ddRoot.setAttribute("descriptorID", ConversionUtil.bytesToHex(descriptorID));
        SimpleDateFormat tzf = new SimpleDateFormat("Z");
        String timeZone = tzf.format(lastModified);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
        String formattedDate = String.valueOf(df.format(lastModified)) + timeZone.substring(0, 3) + ":" + timeZone.substring(3);
        ddRoot.setAttribute("lastModified", formattedDate);
        this.session.insertNode((Node)ddDocument, (Node)ddRoot, null);
        DeploymentDescriptorImpl dd = new DeploymentDescriptorImpl(ddDocument, this.session);
        dd.setResources(resources);
        dd.setContentUnit(content);
        this.log.exiting(this.getClass().getName(), "createDeploymentDescriptor");
        return dd;
    }

    @Override
    public FixIdentity createFixIdentity(String fixName) {
        this.log.entering(this.getClass().getName(), "createFixIdentity");
        this.session.testParameter(fixName, 1, null);
        Element fixIdentityElement = this.session.createCommonElement("Fix");
        FixIdentityImpl fixIdentity = new FixIdentityImpl(fixIdentityElement, this.session);
        fixIdentity.setFixName(fixName);
        this.log.exiting(this.getClass().getName(), "createFixIdentity");
        return fixIdentity;
    }

    @Override
    public Identity createIdentity(TranslatableString name) {
        this.log.entering(this.getClass().getName(), "createIdentity");
        this.session.testParameter(name, 1, null);
        Element identityElement = this.session.createCommonElement("Identity");
        IdentityImpl identity = new IdentityImpl(identityElement, this.session);
        identity.setName(name);
        this.log.exiting(this.getClass().getName(), "createIdentity");
        return identity;
    }

    @Override
    public ManufacturerInformation createManufacturerInformation(TranslatableString name) {
        this.log.entering(this.getClass().getName(), "createManufacturerInformation");
        this.session.testParameter(name, 1, null);
        Element manuInfoElement = this.session.createCommonElement("Manufacturer");
        ManufacturerInformationImpl manuInfo = new ManufacturerInformationImpl(manuInfoElement, this.session);
        manuInfo.setName(name);
        this.log.exiting(this.getClass().getName(), "createManufacturerInformation");
        return manuInfo;
    }

    @Override
    public MaintenanceInformation createMaintenanceInformation() {
        this.log.entering(this.getClass().getName(), "createMaintenanceInformation");
        Element maintInfoElement = this.session.createCommonElement("MaintenanceInformation");
        MaintenanceInformationImpl maintInfo = new MaintenanceInformationImpl(maintInfoElement, this.session);
        this.log.exiting(this.getClass().getName(), "createMaintenanceInformation");
        return maintInfo;
    }

    @Override
    public MaintenanceInformation createSupersedes() {
        this.log.entering(this.getClass().getName(), "createSupersedes");
        Element maintInfoElement = this.session.createCommonElement("Supersedes");
        MaintenanceInformationImpl maintInfo = new MaintenanceInformationImpl(maintInfoElement, this.session);
        this.log.exiting(this.getClass().getName(), "createSupersedes");
        return maintInfo;
    }

    @Override
    public PackageDescriptor createPackageDescriptor(String schemaVersion, byte[] descriptorID, Date lastModified, PackageIdentity identity, Collection<PackageContent> packageContents) {
        this.log.entering(this.getClass().getName(), "createPackageDescriptor");
        this.session.testParameter(schemaVersion, 1, null);
        this.session.testParameter(descriptorID, 2, null);
        this.session.testParameter(lastModified, 3, null);
        this.session.testParameter(identity, 4, null);
        this.session.testParameter(packageContents, 5, null);
        Document pdDocument = this.session.getDocumentBuilder().newDocument();
        Element pdRoot = this.session.createDeploymentElement("DeploymentDescriptor");
        pdRoot.setAttribute("xmlns:sdd-common", "http://docs.oasis-open.org/sdd/ns/common");
        pdRoot.setAttribute("schemaVersion", schemaVersion);
        pdRoot.setAttribute("descriptorID", new String(descriptorID));
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        pdRoot.setAttribute("lastModified", df.format(lastModified));
        this.session.insertNode((Node)pdDocument, (Node)pdRoot, null);
        PackageDescriptorImpl pd = new PackageDescriptorImpl(pdDocument, this.session);
        pd.setPackageContents(packageContents);
        pd.setPackageIdentity(identity);
        this.log.exiting(this.getClass().getName(), "createPackageDescriptor");
        return pd;
    }

    @Override
    public PackageContent createPackageContent(String contentID, String pathName) {
        this.log.entering(this.getClass().getName(), "createPackageContent");
        this.session.testParameter(contentID, 1, null);
        this.session.testParameter(pathName, 2, null);
        Element pkgContentElement = this.session.createPackageElement("Content");
        PackageContentImpl pkgContent = new PackageContentImpl(pkgContentElement, this.session);
        pkgContent.setContentID(contentID);
        pkgContent.setPathname(pathName);
        this.log.exiting(this.getClass().getName(), "createPackageContent");
        return pkgContent;
    }

    @Override
    public PackageIdentity createPackageIdentity() {
        this.log.entering(this.getClass().getName(), "createPackageIdentity");
        Element pkgIdentityElement = this.session.createPackageElement("PackageIdentity");
        PackageIdentityImpl pkgIdentity = new PackageIdentityImpl(pkgIdentityElement, this.session);
        this.log.exiting(this.getClass().getName(), "createPackageIdentity");
        return pkgIdentity;
    }

    @Override
    public Resource createHostedResource(String resourceID, String resourceType) {
        this.log.entering(this.getClass().getName(), "createHostedResource");
        Resource resource = this.createResource(resourceID, resourceType, true);
        this.log.exiting(this.getClass().getName(), "createHostedResource");
        return resource;
    }

    @Override
    public Resource createResource(String resourceID, String resourceType) {
        this.log.entering(this.getClass().getName(), "createResource");
        Resource resource = this.createResource(resourceID, resourceType, false);
        this.log.exiting(this.getClass().getName(), "createResource");
        return resource;
    }

    private Resource createResource(String resourceID, String resourceType, boolean isHostedResource) {
        this.session.testParameter(resourceID, 1, null);
        this.session.testParameter(resourceType, 2, null);
        Element resourceElement = null;
        resourceElement = isHostedResource ? this.session.createDeploymentElement("HostedResource") : this.session.createDeploymentElement("Resource");
        ResourceImpl resource = new ResourceImpl(resourceElement, this.session);
        resource.setResourceID(resourceID);
        resource.setResourceType(resourceType);
        return resource;
    }

    @Override
    public ReferencedPackage createReferencedPackage(String contentRef, String id) {
        this.log.entering(this.getClass().getName(), "createReferencedPackage");
        ReferencedPackage referencedPackage = this.createReferencedPackage(contentRef, id, "ReferencedPackage");
        this.log.exiting(this.getClass().getName(), "createReferencedPackage");
        return referencedPackage;
    }

    @Override
    public ReferencedPackage createContainedPackage(String contentRef, String id) {
        this.log.entering(this.getClass().getName(), "createContainedPackage");
        ReferencedPackage referencedPackage = this.createReferencedPackage(contentRef, id, "ContainedPackage");
        this.log.exiting(this.getClass().getName(), "createContainedPackage");
        return referencedPackage;
    }

    @Override
    public ReferencedPackage createContainedLocalizationPackage(String contentRef, String id) {
        this.log.entering(this.getClass().getName(), "createContainedLocalizationPackage");
        ReferencedPackage referencedPackage = this.createReferencedPackage(contentRef, id, "ContainedLocalizationPackage");
        this.log.exiting(this.getClass().getName(), "createContainedLocalizationPackage");
        return referencedPackage;
    }

    private ReferencedPackage createReferencedPackage(String contentRef, String id, String tagName) {
        this.session.testParameter(contentRef, 1, null);
        this.session.testParameter(id, 2, null);
        Element refedPkgElement = this.session.createDeploymentElement(tagName);
        ReferencedPackageImpl referencedPkg = new ReferencedPackageImpl(refedPkgElement, this.session);
        referencedPkg.setReferencedPackageID(id);
        referencedPkg.setContentReference(contentRef);
        return referencedPkg;
    }

    @Override
    public ResultingChangeMap createResultingChangeMap(String resourceRef) {
        this.log.entering(this.getClass().getName(), "createResultingChangeMap");
        this.session.testParameter(resourceRef, 1, null);
        Element resultingChangeMapElement = this.session.createDeploymentElement("ResultingChangeMap");
        ResultingChangeMapImpl resultingChangeMap = new ResultingChangeMapImpl(resultingChangeMapElement, this.session);
        resultingChangeMap.setResourceReference(resourceRef);
        this.log.exiting(this.getClass().getName(), "createResultingChangeMap");
        return resultingChangeMap;
    }

    @Override
    public ResultingResourceMap createResultingResourceMap(String resourceRef) {
        this.log.entering(this.getClass().getName(), "createResultingResourceMap");
        this.session.testParameter(resourceRef, 1, null);
        Element resultingResMapElement = this.session.createDeploymentElement("ResultingResourceMap");
        ResultingResourceMapImpl resultingResourceMap = new ResultingResourceMapImpl(resultingResMapElement, this.session);
        resultingResourceMap.setResourceReference(resourceRef);
        this.log.exiting(this.getClass().getName(), "createResultingResourceMap");
        return resultingResourceMap;
    }

    @Override
    public ResourceMap createRequiredResourceMap(String resourceRef) {
        this.log.entering(this.getClass().getName(), "createRequiredResourceMap");
        this.session.testParameter(resourceRef, 1, null);
        Element resourceMapElement = this.session.createDeploymentElement("RequiredResourceMap");
        ResourceMapImpl resourceMap = new ResourceMapImpl(resourceMapElement, this.session);
        resourceMap.setResourceReference(resourceRef);
        this.log.exiting(this.getClass().getName(), "createRequiredResourceMap");
        return resourceMap;
    }
}

