/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.CompositeInstallable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ParameterGroup;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.CompositeUnitType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.ConditionType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.ConfigurationUnitType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.DerivedVariableType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.IdentityType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.InstallableUnitType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.LanguageType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.LocalizationUnitType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.ParameterGroupType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.ReferencedPackageType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.RequiredBaseType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.RequirementType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.ResourcePropertyType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.ResultingChangeType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.ResultingResourceType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.StringType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeInstallableType {
    public static Collection<CompositeInstallable> merge(Collection<CompositeInstallable> compositeInstallables1, Collection<CompositeInstallable> compositeInstallables2) {
        ArrayList<CompositeInstallable> compositeInstallablesToRemove = new ArrayList<CompositeInstallable>();
        for (CompositeInstallable compositeInstallable1 : compositeInstallables1) {
            for (CompositeInstallable compositeInstallable2 : compositeInstallables2) {
                if (compositeInstallablesToRemove.contains(compositeInstallable2) || !CompositeInstallableType.equals(compositeInstallable1, compositeInstallable2)) continue;
                compositeInstallablesToRemove.add(compositeInstallable2);
                compositeInstallable1 = CompositeInstallableType.merge(compositeInstallable1, compositeInstallable2);
            }
        }
        compositeInstallables2.removeAll(compositeInstallablesToRemove);
        ArrayList<CompositeInstallable> finalCompositeInstallables = new ArrayList<CompositeInstallable>();
        finalCompositeInstallables.addAll(compositeInstallables1);
        finalCompositeInstallables.addAll(compositeInstallables2);
        return finalCompositeInstallables;
    }

    public static boolean equals(CompositeInstallable iu1, CompositeInstallable iu2) {
        if (StringType.equals(iu1.getOperation(), iu2.getOperation())) {
            if (iu1.getResultingResources() == null && iu1.getResultingResources() != null) {
                return false;
            }
            if (iu1.getResultingResources() != null && iu1.getResultingResources() == null) {
                return false;
            }
            if (iu1.getResultingResources() != null && iu1.getResultingResources() != null && !ResultingResourceType.equals(iu1.getResultingResources(), iu2.getResultingResources())) {
                return false;
            }
            if (iu1.getResultingChanges() == null && iu1.getResultingChanges() != null) {
                return false;
            }
            if (iu1.getResultingChanges() != null && iu1.getResultingChanges() == null) {
                return false;
            }
            return iu1.getResultingChanges() == null || iu1.getResultingChanges() == null || ResultingChangeType.equals(iu1.getResultingChanges(), iu2.getResultingChanges());
        }
        return false;
    }

    public static CompositeInstallable merge(CompositeInstallable compositeInstallable1, CompositeInstallable compositeInstallable2) {
        compositeInstallable1.setIdentityData(IdentityType.merge(compositeInstallable1.getIdentityData(), compositeInstallable2.getIdentityData()));
        compositeInstallable1.setCondition(ConditionType.merge(compositeInstallable1.getCondition(), compositeInstallable2.getCondition()));
        compositeInstallable1.setDerivedVariables(DerivedVariableType.merge(compositeInstallable1.getDerivedVariables(), compositeInstallable2.getDerivedVariables()));
        compositeInstallable1.setResourceProperties(ResourcePropertyType.merge(compositeInstallable1.getResourceProperties(), compositeInstallable2.getResourceProperties()));
        ParameterGroup params = ParameterGroupType.merge(compositeInstallable1.getParameterGroups(), compositeInstallable2.getParameterGroups());
        ArrayList<ParameterGroup> myParams = new ArrayList<ParameterGroup>();
        myParams.add(params);
        compositeInstallable1.setParameterGroups(myParams);
        compositeInstallable1.setRequiredBase(RequiredBaseType.merge(compositeInstallable1.getRequiredBase(), compositeInstallable2.getRequiredBase()));
        compositeInstallable1.setRequirements(RequirementType.merge(compositeInstallable1.getRequirements(), compositeInstallable2.getRequirements()));
        compositeInstallable1.setMandatoryLanguages(LanguageType.merge(compositeInstallable1.getMandatoryLanguages(), compositeInstallable2.getMandatoryLanguages()));
        compositeInstallable1.setOptionalLanguages(LanguageType.merge(compositeInstallable1.getOptionalLanguages(), compositeInstallable2.getOptionalLanguages()));
        compositeInstallable1.setBaseCompositeUnits(CompositeUnitType.merge(compositeInstallable1.getBaseCompositeUnits(), compositeInstallable2.getBaseCompositeUnits()));
        compositeInstallable1.setBaseConfigurationUnits(ConfigurationUnitType.merge(compositeInstallable1.getBaseConfigurationUnits(), compositeInstallable2.getBaseConfigurationUnits()));
        compositeInstallable1.setBaseContainedPackages(ReferencedPackageType.merge(compositeInstallable1.getBaseContainedPackages(), compositeInstallable2.getBaseContainedPackages()));
        compositeInstallable1.setBaseInstallableUnits(InstallableUnitType.merge(compositeInstallable1.getBaseInstallableUnits(), compositeInstallable2.getBaseInstallableUnits()));
        compositeInstallable1.setSelectableCompositeUnits(CompositeUnitType.merge(compositeInstallable1.getSelectableCompositeUnits(), compositeInstallable2.getSelectableCompositeUnits()));
        compositeInstallable1.setSelectableConfigurationUnits(ConfigurationUnitType.merge(compositeInstallable1.getSelectableConfigurationUnits(), compositeInstallable2.getSelectableConfigurationUnits()));
        compositeInstallable1.setSelectableContainedPackages(ReferencedPackageType.merge(compositeInstallable1.getSelectableContainedPackages(), compositeInstallable2.getSelectableContainedPackages()));
        compositeInstallable1.setSelectableInstallableUnits(InstallableUnitType.merge(compositeInstallable1.getSelectableInstallableUnits(), compositeInstallable2.getSelectableInstallableUnits()));
        compositeInstallable1.setLocalizationUnits(LocalizationUnitType.merge(compositeInstallable1.getLocalizationUnits(), compositeInstallable2.getLocalizationUnits()));
        return compositeInstallable1;
    }
}

