/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.DeploymentDescriptor;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact.Artifact;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.CompositeInstallable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.InstallableUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Language;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.LocalizationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ConfigurationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ResultingResource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.DerivedVariable;



public class ArtifactType {

	public static Collection <Artifact> merge(Collection <Artifact> artifacts1, Collection <Artifact> artifacts2)
	{
		// set to hold all the merged variables
		Collection <Artifact> artifactsToRemove = new ArrayList <Artifact> ();
		Iterator <Artifact> artifactIter1 = artifacts1.iterator();		
		//iterate through the artifacts
		while (artifactIter1.hasNext())
		{
			Artifact artifact1 = (Artifact) artifactIter1.next();
			Iterator <Artifact> artifactIter2 = artifacts2.iterator();
			while (artifactIter2.hasNext())
			{
				Artifact artifact2 = (Artifact) artifactIter2.next();
				//if you find a match that hasn't been found, note it
				//one of the equals needs to be deleted with its children merged over
				if (artifactsToRemove.contains(artifact2)==false)
				{
					if (equals(artifact1, artifact2))
					{  //merge hosted artifacts, types and description artifacts
						artifactsToRemove.add(artifact2);						
						artifact1 = merge(artifact1,artifact2);						
					}
				}
					
			}
		}
		
		artifacts2.removeAll(artifactsToRemove);
		//remove all of the matches that were found
		
		Collection <Artifact> finalArtifacts = new ArrayList <Artifact> ();
		//create and return a new collection with all of the remaining items
		finalArtifacts.addAll(artifacts1);
		finalArtifacts.addAll(artifacts2);		
		
		return finalArtifacts;
		
	}
	
	public static Artifact merge(Artifact artifact1, Artifact artifact2)
	{
		artifact1.setPackageType(StringType.merge(artifact1.getPackageType(), artifact2.getPackageType()));
		
		if ((artifact1.getWeight()==null)&&(artifact2.getWeight()!=null))
			artifact1.setWeight(artifact2.getWeight());
		if ((artifact1.getWeight()!=null)&&(artifact2.getWeight()!=null))
			if (artifact1.getWeight().compareTo(artifact2.getWeight())<0)
				artifact1.setWeight(artifact2.getWeight());
		
		//Can't get Arguments due to restriction on spi
		//same for output variables
		
		artifact1.setAdditionalContents(AdditionalContentType.merge(artifact1.getAdditionalContents(), artifact2.getAdditionalContents()));
		
		return artifact1;
	}

	public static boolean equals(Artifact artifact1, Artifact artifact2)
	{
		
		if ((artifact1.getContentReference()!=null)&&(artifact2.getContentReference()==null))
			return false;
		if ((artifact2.getContentReference()!=null)&&(artifact1.getContentReference()==null))
			return false;
		if ((artifact1.getContentReference()!=null)&&(artifact2.getContentReference()!=null))
		{
			
			if (!ContentType.equals(Util.resolveContentRef(artifact1.getContentReference()),Util.resolveContentRef(artifact2.getContentReference())))
				return false;
			
		}
		
		if ((artifact1.getResourceReference()!=null)&&(artifact2.getResourceReference()==null))
			return false;
		if ((artifact2.getResourceReference()!=null)&&(artifact1.getResourceReference()==null))
			return false;
		if ((artifact1.getResourceReference()!=null)&&(artifact2.getResourceReference()!=null))
		{
			
			if (!ResourceType.equals(Util.resolveResourceRef(artifact1.getResourceReference()),Util.resolveResourceRef(artifact2.getResourceReference())))
				return false;
			
		}
		
		return true;
			
	}
	
}
