/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.FixIdentity;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.MaintenanceInformation;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.w3c.dom.Element;

public class MaintenanceInformationImpl extends SPIDataObject implements MaintenanceInformation {
	private static final String MAINTENANCE_INFORMATION_TYPE = "sdd-common:MaintenanceInformationType";

	public MaintenanceInformationImpl(Element element, SPISessionImpl session) {
        super(element, session, MAINTENANCE_INFORMATION_TYPE);
    }

    public Collection<TranslatableString> getCategory() {
        Collection<TranslatableString> maintenanceCategories = new ArrayList<TranslatableString>();
        Collection<Element> maintenanceCategoryList = getChildren("Category");

        for (Element maintenanceCategory : maintenanceCategoryList) {
            maintenanceCategories.add(new TranslatableString(maintenanceCategory));
        }

        return maintenanceCategories;
    }

    public Collection<FixIdentity> getFixIdentityDefinitions() {
        Collection<Element> fixList = getChildren("Fix");
        Collection<FixIdentity> fixes = new ArrayList<FixIdentity>();
        
        for (Element fixElement : fixList) {
            fixes.add(new FixIdentityImpl(fixElement, session));
        }
        
        return fixes;
    }

    public TranslatableString getSeverity() {
    	TranslatableString value = null;
        
        if (isSetElement("Severity")) {
            value = new TranslatableString(getChild("Severity"));
        }
        
        return value;
    }

    public Collection<MaintenanceInformation> getSupersedes() {
        Collection<Element> supersedesList = getChildren("Supersedes");
        Collection<MaintenanceInformation> supersedes = new ArrayList<MaintenanceInformation>();
        
        for (Element supersede : supersedesList) {
            supersedes.add(new MaintenanceInformationImpl(supersede, session));
        }
        
        return supersedes;
    }

    public void setCategory(Collection<TranslatableString> category) {
        if (category == null) {
        	unSetElement("Category");
        }
        else {
			Collection<Element> categoryElements = new ArrayList<Element>();
			removeContent(getChildren("Category", false));
			
			for (TranslatableString categoryTs : category) {
				Element element = session.createCommonElement("Category");
				element.setTextContent(categoryTs.getValue());
				element.setAttribute("translationKey", categoryTs.getTranslationKey());
				
				categoryElements.add(element);
			}
			
			addContent(categoryElements);
        }
    }

    public void setFixIdentityDefinitions(Collection<FixIdentity> fixIdentityDefinitions) {
        if (fixIdentityDefinitions == null) {
        	unSetElement("Fix");
        }
        else {
        	removeContent(getChildren("Fix", false));
            
            addContent(fixIdentityDefinitions);
        }
    }

    public void setSeverity(TranslatableString severity) {
        if (severity == null) {
            unSetElement("Severity");
        }
        else {
			Element element = session.createCommonElement("Severity");
			element.setTextContent(severity.getValue());
			element.setAttribute("translationKey", severity.getTranslationKey());

        	setContent(element);
        }
    }

    public void setSupersedes(Collection<MaintenanceInformation> maintenanceInformation) {
    	if (maintenanceInformation == null) {
    		unSetElement("Supersedes");
    	}
    	else {
    		removeContent(getChildren("Supersedes", false));
    		
    		addContent(maintenanceInformation);
    	}
    }

    public Object clone() {
        return new MaintenanceInformationImpl((Element)getElement().cloneNode(true), session);
    }
}