/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.ReferencedPackageImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition.ConditionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requiredbase.RequiredBaseImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement.RequirementImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ReferencedPackage;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.Condition;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.CompositeInstallable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.CompositeLocalizationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.CompositeUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ConfigurationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Feature;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Group;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.InstallableUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Language;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.LanguageSet;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.LocalizationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.MultiFeatureSelect;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ResultingChange;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ResultingResource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.RequiredBase;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.Requirement;
import org.w3c.dom.Element;

public class CompositeInstallableImpl extends ContentUnitImpl implements CompositeInstallable {
	private static final String COMPOSITE_INSTALLABLE_TYPE = "sdd-dd:CompositeInstallableType";
	private static final String BASE_CONTENT_TYPE = "sdd-dd:BaseContentType";
	private static final String LANGUAGES_TYPE = "sdd-dd:LanguagesType";
	private static final String LANGUAGE_SELECTIONS_TYPE = "sdd-dd:LanguageSelectionsType";
	private static final String OPTIONAL_LANGUAGES_TYPE = "sdd-dd:OptionalLanguagesType";
	private static final String LOCALIZATION_CONTENT_TYPE = "sdd-dd:LocalizationContentType";
	private static final String FEATURES_TYPE = "sdd-dd:FeaturesType";
	private static final String SELECTABLE_CONTENT_TYPE = "sdd-dd:SelectableContentType";
	private static final String GROUPS_TYPE = "sdd-dd:GroupsType";
	private static final String REQUIREMENTS_TYPE = "sdd-dd:RequirementsType";
	
    public CompositeInstallableImpl(Element cido, SPISessionImpl session) {
        super(cido, session, COMPOSITE_INSTALLABLE_TYPE);
    }

    public Element getCompositeInstallableTypeDataObject() {
        return getElement();
    }
    
    public String getOperation() {
	    return getAttribute("operation");
	}

    public Collection<CompositeUnit> getBaseCompositeUnits() {
        Collection<CompositeUnit> compositeUnits = new ArrayList<CompositeUnit>();

        if (isSetElement("BaseContent")) {
            Collection<Element> baseCompositeUnitElementList = 
            	session.getChildren(getChild("BaseContent"), "CompositeUnit");

            for (Element element : baseCompositeUnitElementList) {
                compositeUnits.add(new CompositeUnitImpl(element, session));
            }
        }

        return compositeUnits;
    }

    public Collection<ConfigurationUnit> getBaseConfigurationUnits() {
        Collection<ConfigurationUnit> configurationUnits = new ArrayList<ConfigurationUnit>();

        if (isSetElement("BaseContent")) {
            Collection<Element> baseConfigurationUnitElementList = 
            	session.getChildren(getChild("BaseContent"), "ConfigurationUnit");

            for (Element element : baseConfigurationUnitElementList) {
                configurationUnits.add(new ConfigurationUnitImpl(element, session));
            }
        }

        return configurationUnits;
    }

    public Collection<ReferencedPackage> getBaseContainedPackages() {
        Collection<ReferencedPackage> containedpackages = new ArrayList<ReferencedPackage>();

        if (isSetElement("BaseContent")) {
            Collection<Element> baseContainedPackageElementList =
            	session.getChildren(getChild("BaseContent"), "ContainedPackage");

            for (Element element : baseContainedPackageElementList) {
                containedpackages.add(new ReferencedPackageImpl(element, session));
            }
        }

        return containedpackages;
    }

    public Collection<InstallableUnit> getBaseInstallableUnits() {
        Collection<InstallableUnit> installableUnits = new ArrayList<InstallableUnit>();

        if (isSetElement("BaseContent")) {
            Collection<Element> baseInstallableUnitElementList =
            	session.getChildren(getChild("BaseContent"), "InstallableUnit");

            for (Element element : baseInstallableUnitElementList) {
                installableUnits.add(new InstallableUnitImpl(element, session));
            }
        }

        return installableUnits;
    }

    public Collection<Language> getMandatoryLanguages() {
        Collection<Language> languages = new ArrayList<Language>();

        if (isSetElement("Languages") && !session.getChildren(getChild("Languages"), "Mandatory").isEmpty()) {
            Collection<Element> languageElementList =
            	session.getChildren(session.getChild(getChild("Languages"), "Mandatory"), "Language");

            for (Element element : languageElementList) {
                languages.add(new LanguageImpl(element, session));
            }
        }

        return languages;
    }

    public Collection<Language> getOptionalLanguages() {
        Collection<Language> languages = new ArrayList<Language>();

        if (isSetElement("Languages") && !session.getChildren(getChild("Languages"), "Optional").isEmpty()) {
            Collection<Element> languageElementList =
            	session.getChildren(session.getChild(getChild("Languages"), "Optional"), "Language");

            for (Element element : languageElementList) {
                languages.add(new LanguageImpl(element, session));
            }
        }

        return languages;
    }

    public Collection<LanguageSet> getOptionalLanguageSets() {
        Collection<LanguageSet> languages = new ArrayList<LanguageSet>();

        if (isSetElement("Languages") && !session.getChildren(getChild("Languages"), "Optional").isEmpty()) {
            Collection<Element> languageElementList =
            	session.getChildren(session.getChild(getChild("Languages"), "Optional"), "LanguageSet");

            for (Element element : languageElementList) {
                languages.add(new LanguageSetImpl(element, session));
            }
        }

        return languages;
    }

    public Collection<CompositeLocalizationUnit> getCompositeLocalizationUnits() {
        Collection<CompositeLocalizationUnit> compositeLocalizationUnits = new ArrayList<CompositeLocalizationUnit>();

        if (isSetElement("LocalizationContent")) {
            Collection<Element> localizationElementList =
            	session.getChildren(getChild("LocalizationContent"), "CompositeLocalizationUnit");

            for (Element element : localizationElementList) {
                compositeLocalizationUnits.add(new CompositeLocalizationUnitImpl(element, session));
            }
        }

        return compositeLocalizationUnits;
    }

    public Condition getCondition() {
        Condition c = null;
        
        if (isSetElement("Condition")) {
            c = new ConditionImpl(getChild("Condition"), session);
        }

        return c;
    }

    public Collection<ReferencedPackage> getContainedLocalizationPackages() {
        Collection<ReferencedPackage> packages = new ArrayList<ReferencedPackage>();

        if (isSetElement("LocalizationContent")) {
            Collection<Element> localizationElementList =
            	session.getChildren(getChild("LocalizationContent"), "ContainedLocalizationPackage");

            for (Element element : localizationElementList) {
                packages.add(new ReferencedPackageImpl(element, session));
            }
        }

        return packages;
    }

    public Collection<Feature> getFeatures() {
        Collection<Feature> features = new ArrayList<Feature>();

        if (isSetElement("SelectableContent") &&
        		!session.getChildren(getChild("SelectableContent"), "Features").isEmpty()) {
            Collection<Element> featureElementList =
            	session.getChildren(session.getChild(getChild("SelectableContent"), "Features"), "Feature");

            for (Element element : featureElementList) {
                features.add(new FeatureImpl(element, session));
            }
        }

        return features;
    }

    public Collection<MultiFeatureSelect> getMultiFeatureSelects() {
        Collection<MultiFeatureSelect> features = new ArrayList<MultiFeatureSelect>();

        if (isSetElement("SelectableContent") &&
        		!session.getChildren(getChild("SelectableContent"), "Features").isEmpty()) {
            Collection<Element> featureElementList =
            	session.getChildren(session.getChild(getChild("SelectableContent"), "Features"), "MultiSelect");

            for (Element element : featureElementList) {
                features.add(new MultiFeatureSelectImpl(element, session));
            }
        }

        return features;
    }

    public Collection<Group> getGroups() {
        Collection<Group> groups = new ArrayList<Group>();

        if (isSetElement("SelectableContent") &&
        		!session.getChildren(getChild("SelectableContent"), "Groups").isEmpty()) {
            Collection<Element> groupElementList = session.getChildren(session.getChild(getChild("SelectableContent"), "Groups"), "Group");

            for (Element element : groupElementList) {
                groups.add(new GroupImpl(element, session));
            }
        }

        return groups;
    }

    public Collection<LocalizationUnit> getLocalizationUnits() {
        Collection<LocalizationUnit> localizationUnits = new ArrayList<LocalizationUnit>();

        if (isSetElement("LocalizationContent")) {
            Collection<Element> localizationElementList =
            	session.getChildren(getChild("LocalizationContent"), "LocalizationUnit");

            for (Element element : localizationElementList) {
                localizationUnits.add(new LocalizationUnitImpl(element, session));
            }
        }

        return localizationUnits;
    }

    public RequiredBase getRequiredBase() {
        RequiredBase requiredBase = null;

        if (isSetElement("RequiredBase")) {
            requiredBase = new RequiredBaseImpl(getChild("RequiredBase"), session);
        }

        return requiredBase;
    }

    public Collection<Requirement> getRequirements() {
        Collection<Requirement> localizationUnits = new ArrayList<Requirement>();

        if (isSetElement("Requirements")) {
            Collection<Element> localizationElementList = session.getChildren(getChild("Requirements"), "Requirement");

            for (Element element : localizationElementList) {
                localizationUnits.add(new RequirementImpl(element, session));
            }
        }

        return localizationUnits;
    }

    public Collection<ResultingChange> getResultingChanges() {
        Collection<Element> resultingChangeElements = getChildren("ResultingChange");
        Collection<ResultingChange> resultingChanges = new ArrayList<ResultingChange>();

        for (Element element : resultingChangeElements) {
            resultingChanges.add(new ResultingChangeImpl(element, session));
        }

        return resultingChanges;
    }

    public Collection<ResultingResource> getResultingResources() {
        Collection<Element> resultingResourceElements = getChildren("ResultingResource");
        Collection<ResultingResource> resultingResources = new ArrayList<ResultingResource>();

        for (Element element : resultingResourceElements) {
            resultingResources.add(new ResultingResourceImpl(element, session));
        }

        return resultingResources;
    }

    public Collection<CompositeUnit> getSelectableCompositeUnits() {
        Collection<CompositeUnit> compositeUnits = new ArrayList<CompositeUnit>();

        if (isSetElement("SelectableContent")) {
            Collection<Element> baseCompositeUnitElementList =
            	session.getChildren(getChild("SelectableContent"), "CompositeUnit");

            for (Element element : baseCompositeUnitElementList) {
                compositeUnits.add(new CompositeUnitImpl(element, session));
            }
        }

        return compositeUnits;
    }

    public Collection<ConfigurationUnit> getSelectableConfigurationUnits() {
        Collection<ConfigurationUnit> configurationUnits = new ArrayList<ConfigurationUnit>();

        if (isSetElement("SelectableContent")) {
            Collection<Element> baseConfigurationUnitElementList =
            	session.getChildren(getChild("SelectableContent"), "ConfigurationUnit");

            for (Element element : baseConfigurationUnitElementList) {
                configurationUnits.add(new ConfigurationUnitImpl(element, session));
            }
        }

        return configurationUnits;
    }

    public Collection<ReferencedPackage> getSelectableContainedPackages() {
        Collection<ReferencedPackage> containedpackages = new ArrayList<ReferencedPackage>();

        if (isSetElement("SelectableContent")) {
            Collection<Element> baseContainedPackageElementList =
            	session.getChildren(getChild("SelectableContent"), "ContainedPackage");

            for (Element element : baseContainedPackageElementList) {
                containedpackages.add(new ReferencedPackageImpl(element, session));
            }
        }

        return containedpackages;
    }

    public Collection<InstallableUnit> getSelectableInstallableUnits() {
        Collection<InstallableUnit> installableUnits = new ArrayList<InstallableUnit>();

        if (isSetElement("SelectableContent")) {
            Collection<Element> baseInstallableUnitElementList =
            	session.getChildren(getChild("SelectableContent"), "InstallableUnit");

            for (Element element : baseInstallableUnitElementList) {
                installableUnits.add(new InstallableUnitImpl(element, session));
            }
        }

        return installableUnits;
    }
    
    public void setOperation(String operation) {
		session.testParameter(operation, 1, null);

		setAttribute("operation", operation);
	}

    public void setBaseCompositeUnits(Collection<CompositeUnit> compositeUnits) {
        Element baseContent;

        if (isSetElement("BaseContent")) {
            baseContent = getChild("BaseContent");
        }
        else {
            baseContent = session.createDeploymentElement("BaseContent");
        }
        
        if (compositeUnits != null && !compositeUnits.isEmpty()) {
            //Remove all CompositeUnit elements
            Collection<Element> compositeUnitNodeList = session.getChildren(baseContent, "CompositeUnit");
            for (Element element : compositeUnitNodeList) {
                baseContent.removeChild(element);
            }
            
            for (CompositeUnit compositeUnit : compositeUnits) {
                session.insertNode(baseContent, (SPIDataObject) compositeUnit, BASE_CONTENT_TYPE);
            }

            setContent(baseContent);
        }
        else {
            //Remove all CompositeUnit elements
            Collection<Element> compositeUnitNodeList = session.getChildren(baseContent, "CompositeUnit");
            for (Element element : compositeUnitNodeList) {
                baseContent.removeChild(element);
            }

            if (session.getChildren(baseContent, "CompositeUnit").isEmpty() &&
            		session.getChildren(baseContent, "ConfigurationUnit").isEmpty() &&
            		session.getChildren(baseContent, "ContainedPackage").isEmpty() &&
            		session.getChildren(baseContent, "InstallableUnit").isEmpty()) {
                unSetElement("BaseContent");
            }
        }
    }

    public void setBaseConfigurationUnits(Collection<ConfigurationUnit> configurationUnits) {
        Element baseContent;

        if (isSetElement("BaseContent")) {
            baseContent = getChild("BaseContent");
        }
        else {
            baseContent = session.createDeploymentElement("BaseContent");
        }
        
        if (configurationUnits != null && !configurationUnits.isEmpty()) {
            //Remove all ConfigurationUnit elements
            Collection<Element> compositeUnitNodeList = session.getChildren(baseContent, "ConfigurationUnit");
            for (Element element : compositeUnitNodeList) {
                baseContent.removeChild(element);
            }
            
            for (ConfigurationUnit configurationUnit : configurationUnits) {
                session.insertNode(baseContent, (SPIDataObject) configurationUnit, BASE_CONTENT_TYPE);
            }

            setContent(baseContent);
        }
        else {
            //Remove all ConfigurationUnit elements
            Collection<Element> configurationUnitNodeList = session.getChildren(baseContent, "ConfigurationUnit");
            for (Element element : configurationUnitNodeList) {
                baseContent.removeChild(element);
            }

            if (session.getChildren(baseContent, "CompositeUnit").isEmpty() &&
            		session.getChildren(baseContent, "ConfigurationUnit").isEmpty() &&
            		session.getChildren(baseContent, "ContainedPackage").isEmpty() &&
            		session.getChildren(baseContent, "InstallableUnit").isEmpty()) {
                unSetElement("BaseContent");
            }
        }
    }

    public void setBaseContainedPackages(Collection<ReferencedPackage> containedPackages) {
        Element baseContent;

        if (isSetElement("BaseContent")) {
            baseContent = getChild("BaseContent");
        }
        else {
            baseContent = session.createDeploymentElement("BaseContent");
        }
        
        if (containedPackages != null && !containedPackages.isEmpty()) {
            //Remove all ContainedPackage elements
            Collection<Element> containedPackageNodeList = session.getChildren(baseContent, "ContainedPackage");
            for (Element element : containedPackageNodeList) {
                baseContent.removeChild(element);
            }
            
            for (ReferencedPackage referencedPackage : containedPackages) {
                session.insertNode(baseContent, (SPIDataObject) referencedPackage, BASE_CONTENT_TYPE);
            }

            setContent(baseContent);
        }
        else {
            //Remove all ContainedPackage elements
            Collection<Element> containedPackageNodeList = session.getChildren(baseContent, "ContainedPackage");
            for (Element element : containedPackageNodeList) {
                baseContent.removeChild(element);
            }

            if (session.getChildren(baseContent, "CompositeUnit").isEmpty() &&
            		session.getChildren(baseContent, "ConfigurationUnit").isEmpty() &&
            		session.getChildren(baseContent, "ContainedPackage").isEmpty() &&
            		session.getChildren(baseContent, "InstallableUnit").isEmpty()) {
                unSetElement("BaseContent");
            }
        }
    }

    public void setBaseInstallableUnits(Collection<InstallableUnit> installableUnits) {
        Element baseContent;

        if (isSetElement("BaseContent")) {
            baseContent = getChild("BaseContent");
        }
        else {
            baseContent = session.createDeploymentElement("BaseContent");
        }
        
        if (installableUnits != null && !installableUnits.isEmpty()) {
            //Remove all InstallableUnit elements
            Collection<Element> installableUnitNodeList = session.getChildren(baseContent, "InstallableUnit");
            for (Element element : installableUnitNodeList) {
                baseContent.removeChild(element);
            }
            
            for (InstallableUnit configurationUnit : installableUnits) {
                session.insertNode(baseContent, (SPIDataObject) configurationUnit, BASE_CONTENT_TYPE);
            }

            setContent(baseContent);
        }
        else {
            //Remove all InstallableUnit elements
            Collection<Element> containedPackageNodeList = session.getChildren(baseContent, "InstallableUnit");
            for (Element element : containedPackageNodeList) {
                baseContent.removeChild(element);
            }

            if (session.getChildren(baseContent, "CompositeUnit").isEmpty() &&
            		session.getChildren(baseContent, "ConfigurationUnit").isEmpty() &&
            		session.getChildren(baseContent, "ContainedPackage").isEmpty() &&
            		session.getChildren(baseContent, "InstallableUnit").isEmpty()) {
                unSetElement("BaseContent");
            }
        }
    }

    public void setMandatoryLanguages(Collection<Language> languages) {
        Element languageSelectionsElement;

        if (isSetElement("Languages")) {
            languageSelectionsElement = getChild("Languages");
        }
        else {
            languageSelectionsElement = session.createDeploymentElement("Languages");
        }

        if (languages != null && !languages.isEmpty()) {
            Element mandatoryElement;

            if (isSetElement("Mandatory")) {
                mandatoryElement = getChild("Mandatory");
            }
            else {
                mandatoryElement = session.createDeploymentElement("Mandatory");
            }

            //Remove all Language elements
            Collection<Element> languageNodeList = session.getChildren(mandatoryElement, "Language");
            for (Element element : languageNodeList) {
                mandatoryElement.removeChild(element);
            }
            
            for (Language language : languages) {
                session.insertNode(mandatoryElement, (SPIDataObject) language, LANGUAGES_TYPE);
            }

            //Remove all Manditory elements
            Collection<Element> manditoryNodeList = session.getChildren(languageSelectionsElement, "Mandatory");
            for (Element element : manditoryNodeList) {
                languageSelectionsElement.removeChild(element);
            }
            
            session.insertNode(languageSelectionsElement, mandatoryElement, LANGUAGE_SELECTIONS_TYPE);
            
            setContent(languageSelectionsElement);
        }
        else {
            //Remove all Manditory elements
            Collection<Element> manditoryNodeList = session.getChildren(languageSelectionsElement, "Manditory");
            for (Element element : manditoryNodeList) {
                languageSelectionsElement.removeChild(element);
            }

            if (session.getChildren(languageSelectionsElement, "Manditory").isEmpty() &&
            		session.getChildren(languageSelectionsElement, "Optional").isEmpty()) {
                unSetElement("Languages");
            }
        }
    }

    public void setOptionalLanguages(Collection<Language> languages) {
        Element languageSelectionsElement;

        if (isSetElement("Languages")) {
            languageSelectionsElement = getChild("Languages");
        }
        else {
            languageSelectionsElement = session.createDeploymentElement("Languages");
        }

        if (languages != null && !languages.isEmpty()) {
            Element optionalElement = session.getChild(languageSelectionsElement, "Optional");

            if (optionalElement == null) {
                optionalElement = session.createDeploymentElement("Optional");
            }

            //Remove all Language elements
            Collection<Element> languageNodeList = session.getChildren(optionalElement, "Language");
            for (Element element : languageNodeList) {
                optionalElement.removeChild(element);
            }
            
            for (Language language : languages) {
                session.insertNode(optionalElement, (SPIDataObject) language, OPTIONAL_LANGUAGES_TYPE);
            }

            //Remove all Optional elements
            Collection<Element> optionalNodeList = session.getChildren(languageSelectionsElement, "Optional");
            for (Element element : optionalNodeList) {
                languageSelectionsElement.removeChild(element);
            }
            
            session.insertNode(languageSelectionsElement, optionalElement, LANGUAGE_SELECTIONS_TYPE);
            
            setContent(languageSelectionsElement);
        }
        else {
            //Remove all Optional elements
            Collection<Element> optionalNodeList = session.getChildren(languageSelectionsElement, "Optional");
            for (Element element : optionalNodeList) {
                languageSelectionsElement.removeChild(element);
            }

            if (session.getChildren(languageSelectionsElement, "Manditory").isEmpty() &&
            		session.getChildren(languageSelectionsElement, "Optional").isEmpty()) {
                unSetElement("Languages");
            }
        }
    }

    public void setOptionalLanguageSets(Collection<LanguageSet> languageSets) {
        Element languageSelectionsElement;

        if (isSetElement("Languages")) {
            languageSelectionsElement = getChild("Languages");
        }
        else {
            languageSelectionsElement = session.createDeploymentElement("Languages");
        }

        if (languageSets != null && !languageSets.isEmpty()) {
            Element optionalElement = session.getChild(languageSelectionsElement, "Optional");

            if (optionalElement == null) {
                optionalElement = session.createDeploymentElement("Optional");
            }

            //Remove all LanguageSet elements
            Collection<Element> languageSetNodeList = session.getChildren(optionalElement, "LanguageSet");
            for (Element element : languageSetNodeList) {
                optionalElement.removeChild(element);
            }
            
            for (LanguageSet languageSet : languageSets) {
                session.insertNode(optionalElement, (SPIDataObject) languageSet, OPTIONAL_LANGUAGES_TYPE);
            }

            //Remove all Optional elements
            Collection<Element> optionalNodeList = session.getChildren(languageSelectionsElement, "Optional");
            for (Element element : optionalNodeList) {
                languageSelectionsElement.removeChild(element);
            }
            
            session.insertNode(languageSelectionsElement, optionalElement, LANGUAGE_SELECTIONS_TYPE);
            
            setContent(languageSelectionsElement);
        }
        else {
            //Remove all Optional elements
            Collection<Element> optionalNodeList = session.getChildren(languageSelectionsElement, "Optional");
            for (Element element : optionalNodeList) {
                languageSelectionsElement.removeChild(element);
            }

            if (session.getChildren(languageSelectionsElement, "Manditory").isEmpty() &&
            		session.getChildren(languageSelectionsElement, "Optional").isEmpty()) {
                unSetElement("Languages");
            }
        }
    }

    public void setCompositeLocalizationUnits(Collection<CompositeLocalizationUnit> localizationUnits) {
        Element localizationContent;

        if (isSetElement("LocalizationContent")) {
            localizationContent = getChild("LocalizationContent");
        }
        else {
            localizationContent = session.createDeploymentElement("LocalizationContent");
        }
        
        if (localizationUnits != null && !localizationUnits.isEmpty()) {
            //Remove all CompositeLocalizationUnit elements
            Collection<Element> compositeLocalizationUnitNodeList =
            	session.getChildren(localizationContent, "CompositeLocalizationUnit");
            for (Element element : compositeLocalizationUnitNodeList) {
                localizationContent.removeChild(element);
            }
            
            for (CompositeLocalizationUnit localizationUnit : localizationUnits) {
                session.insertNode(localizationContent, (SPIDataObject) localizationUnit, LOCALIZATION_CONTENT_TYPE);
            }

            setContent(localizationContent);
        }
        else {
            //Remove all CompositeLocalizationUnit elements
            Collection<Element> compositeLocalizationUnitNodeList =
            	session.getChildren(localizationContent, "CompositeLocalizationUnit");
            for (Element element : compositeLocalizationUnitNodeList) {
                localizationContent.removeChild(element);
            }

            if (session.getChildren(localizationContent, "CompositeLocalizationUnit").isEmpty() &&
            		session.getChildren(localizationContent, "ContainedLocalizationPackage").isEmpty() &&
            		session.getChildren(localizationContent, "LocalizationUnit").isEmpty()) {
                unSetElement("LocalizationContent");
            }
        }
    }

    public void setCondition(Condition condition) {
        if (condition == null) {
            unSetElement("Condition");
        }
        else {
            setContent((SPIDataObject) condition);
        }
    }

    public void setContainedLocalizationPackages(Collection<ReferencedPackage> packages) {
        Element localizationContent;

        if (isSetElement("LocalizationContent")) {
            localizationContent = getChild("LocalizationContent");
        }
        else {
            localizationContent = session.createDeploymentElement("LocalizationContent");
        }
        
        if (packages != null && !packages.isEmpty()) {
            //Remove all ContainedLocalizationPackage elements
            Collection<Element> containedLocalizationPackageNodeList =
            	session.getChildren(localizationContent, "ContainedLocalizationPackage");
            for (Element element : containedLocalizationPackageNodeList) {
                localizationContent.removeChild(element);
            }
            
            for (ReferencedPackage referencedPackage : packages) {
                session.insertNode(localizationContent, (SPIDataObject) referencedPackage, LOCALIZATION_CONTENT_TYPE);
            }

            setContent(localizationContent);
        }
        else {
            //Remove all ContainedLocalizationPackage elements
            Collection<Element> containedLocalizationPackageNodeList =
            	session.getChildren(localizationContent, "ContainedLocalizationPackage");
            for (Element element : containedLocalizationPackageNodeList) {
                localizationContent.removeChild(element);
            }

            if (session.getChildren(localizationContent, "CompositeLocalizationUnit").isEmpty() &&
            		session.getChildren(localizationContent, "ContainedLocalizationPackage").isEmpty() &&
            		session.getChildren(localizationContent, "LocalizationUnit").isEmpty()) {
                unSetElement("LocalizationContent");
            }
        }
    }

    public void setFeatures(Collection<Feature> features) {
        Element selectableContent;

        if (isSetElement("SelectableContent")) {
            selectableContent = getChild("SelectableContent");
        }
        else {
            selectableContent = session.createDeploymentElement("SelectableContent");
        }
        
        Element featuresElement;

        if (session.getChild(selectableContent, "Features") != null) {
            featuresElement = session.getChild(selectableContent, "Features");
        }
        else {
            featuresElement = session.createDeploymentElement("Features");
        }

        if (features != null && !features.isEmpty()) {
            //Remove all Feature elements
            Collection<Element> featuresNodeList = session.getChildren(featuresElement, "Feature");
            for (Element element : featuresNodeList) {
                featuresElement.removeChild(element);
            }
            
            for (Feature compositeUnit : features) {
                session.insertNode(featuresElement, (SPIDataObject) compositeUnit, FEATURES_TYPE);
            }
            
            session.removeChildren(selectableContent, "Features");
            session.insertNode(selectableContent, featuresElement, SELECTABLE_CONTENT_TYPE);

            setContent(selectableContent);
        }
        else {
            //Remove all Feature elements
            Collection<Element> featureNodeList = session.getChildren(featuresElement, "Feature");
            for (Element element : featureNodeList) {
                featuresElement.removeChild(element);
            }

            if (session.getChildren(featuresElement, "Feature").isEmpty() &&
            		session.getChildren(featuresElement, "MultiSelect").isEmpty()) {
                //Remove all Features elements
                Collection<Element> featuresNodeList = session.getChildren(selectableContent, "Features");
                for (Element element : featuresNodeList) {
                    selectableContent.removeChild(element);
                }
                setContent(selectableContent);
            }
            
            if (session.getChildren(selectableContent, "Features").isEmpty() &&
            		session.getChildren(selectableContent, "Groups").isEmpty() &&
            		session.getChildren(selectableContent, "CompositeUnit").isEmpty() &&
            		session.getChildren(selectableContent, "ConfigurationUnit").isEmpty() &&
            		session.getChildren(selectableContent, "ContainedPackage").isEmpty() &&
            		session.getChildren(selectableContent, "InstallableUnit").isEmpty()) {
                unSetElement("SelectableContent");
            }
        }
    }

    public void setMultiFeatureSelects(Collection<MultiFeatureSelect> multiFeatureSelects) {
        Element selectableContent;

        if (isSetElement("SelectableContent")) {
            selectableContent = getChild("SelectableContent");
        }
        else {
            selectableContent = session.createDeploymentElement("SelectableContent");
        }
        
        Element featuresElement;

        if (session.getChild(selectableContent, "Features") != null) {
            featuresElement = session.getChild(selectableContent, "Features");
        }
        else {
            featuresElement = session.createDeploymentElement("Features");
        }

        if (multiFeatureSelects != null && !multiFeatureSelects.isEmpty()) {
            //Remove all MultiSelect elements
            Collection<Element> multiSelectNodeList = session.getChildren(featuresElement, "MultiSelect");
            for (Element element : multiSelectNodeList) {
                featuresElement.removeChild(element);
            }
            
            for (MultiFeatureSelect compositeUnit : multiFeatureSelects) {
                session.insertNode(featuresElement, (SPIDataObject) compositeUnit, FEATURES_TYPE);
            }
            
            session.removeChildren(selectableContent, "Features");
            session.insertNode(selectableContent, featuresElement, SELECTABLE_CONTENT_TYPE);
            
            setContent(selectableContent);
        }
        else {
            //Remove all MultiSelect elements
            Collection<Element> featureNodeList = session.getChildren(featuresElement, "MultiSelect");
            for (Element element : featureNodeList) {
                featuresElement.removeChild(element);
            }

            if (session.getChildren(featuresElement, "Feature").isEmpty() &&
            		session.getChildren(featuresElement, "MultiSelect").isEmpty()) {
                //Remove all Features elements
                Collection<Element> featuresNodeList = session.getChildren(selectableContent, "Features");
                for (Element element : featuresNodeList) {
                    selectableContent.removeChild(element);
                }
                setContent(selectableContent);
            }
            
            if (session.getChildren(selectableContent, "Features").isEmpty() &&
            		session.getChildren(selectableContent, "Groups").isEmpty() &&
            		session.getChildren(selectableContent, "CompositeUnit").isEmpty() &&
            		session.getChildren(selectableContent, "ConfigurationUnit").isEmpty() &&
            		session.getChildren(selectableContent, "ContainedPackage").isEmpty() &&
            		session.getChildren(selectableContent, "InstallableUnit").isEmpty()) {
                unSetElement("SelectableContent");
            }
        }
    }

    public void setGroups(Collection<Group> groups) {
        Element selectableContent;

        if (isSetElement("SelectableContent")) {
            selectableContent = getChild("SelectableContent");
        }
        else {
            selectableContent = session.createDeploymentElement("SelectableContent");
        }
        
        Element groupsElement;

        if (session.getChild(selectableContent, "Groups") != null) {
            groupsElement = session.getChild(selectableContent, "Groups");
        }
        else {
            groupsElement = session.createDeploymentElement("Groups");
        }

        if (groups != null && !groups.isEmpty()) {
            //Remove all Group elements
            Collection<Element> groupsNodeList = session.getChildren(groupsElement, "Group");
            for (Element element : groupsNodeList) {
                groupsElement.removeChild(element);
            }
            
            for (Group compositeUnit : groups) {
                session.insertNode(groupsElement, (SPIDataObject) compositeUnit, GROUPS_TYPE);
            }
            
            session.removeChildren(selectableContent, "Groups");
            session.insertNode(selectableContent, groupsElement, SELECTABLE_CONTENT_TYPE);

            setContent(selectableContent);
        }
        else {
            // Remove all Groups elements
            Collection<Element> groupsNodeList = session.getChildren(selectableContent, "Groups");
            for (Element element : groupsNodeList) {
                selectableContent.removeChild(element);
            }
            setContent(selectableContent);

            if (session.getChildren(selectableContent, "Features").isEmpty() &&
            		session.getChildren(selectableContent, "Groups").isEmpty() &&
            		session.getChildren(selectableContent, "CompositeUnit").isEmpty() &&
            		session.getChildren(selectableContent, "ConfigurationUnit").isEmpty() &&
            		session.getChildren(selectableContent, "ContainedPackage").isEmpty() &&
            		session.getChildren(selectableContent, "InstallableUnit").isEmpty()) {
                unSetElement("SelectableContent");
            }
        }
    }

    public void setLocalizationUnits(Collection<LocalizationUnit> localizationUnits) {
        Element localizationContent;

        if (isSetElement("LocalizationContent")) {
            localizationContent = getChild("LocalizationContent");
        }
        else {
            localizationContent = session.createDeploymentElement("LocalizationContent");
        }
        
        if (localizationUnits != null && !localizationUnits.isEmpty()) {
            //Remove all LocalizationUnit elements
            Collection<Element> localizationUnitNodeList = session.getChildren(localizationContent, "LocalizationUnit");
            for (Element element : localizationUnitNodeList) {
                localizationContent.removeChild(element);
            }
            
            for (LocalizationUnit localizationUnit : localizationUnits) {
                session.insertNode(localizationContent, (SPIDataObject) localizationUnit, LOCALIZATION_CONTENT_TYPE);
            }

            setContent(localizationContent);
        }
        else {
            //Remove all LocalizationUnit elements
            Collection<Element> localizationUnitNodeList = session.getChildren(localizationContent, "LocalizationUnit");
            for (Element element : localizationUnitNodeList) {
                localizationContent.removeChild(element);
            }

            if (session.getChildren(localizationContent, "CompositeLocalizationUnit").isEmpty() &&
            		session.getChildren(localizationContent, "ContainedLocalizationPackage").isEmpty() &&
            		session.getChildren(localizationContent, "LocalizationUnit").isEmpty()) {
                unSetElement("LocalizationContent");
            }
        }
    }

    public void setRequiredBase(RequiredBase requiredBase) {
        if (requiredBase == null) {
            unSetElement("RequiredBase");
        }
        else {
            setContent((SPIDataObject) requiredBase);
        }
    }

    public void setRequirements(Collection<Requirement> requirements) {
        if (requirements != null && !requirements.isEmpty()) {
            Element requirementsDataObject;

            if (isSetElement("Requirements")) {
                requirementsDataObject = getChild("Requirements");
            }
            else {
                requirementsDataObject = session.createDeploymentElement("Requirements");
            }

            //Remove all Requirement elements
            Collection<Element> requirementNodeList = session.getChildren(requirementsDataObject, "Requirement");
            for (Element element : requirementNodeList) {
                requirementsDataObject.removeChild(element);
            }
            
            for (Requirement requirement : requirements) {
                session.insertNode(requirementsDataObject, (SPIDataObject) requirement, REQUIREMENTS_TYPE);
            }

            setContent(requirementsDataObject);
        }
        else {
            unSetElement("Requirements");
        }
    }

    public void setResultingChanges(Collection<ResultingChange> changes) {
        if (changes != null && !changes.isEmpty()) {
            //Remove all ResultingChange elements
            removeContent(getChildren("ResultingChange", false));

            addContent(changes);
        }
        else {
            //Remove all ResultingChange elements
            removeContent(getChildren("ResultingChange", false));
        }
    }

    public void setResultingResources(Collection<ResultingResource> resources) {
        if (resources != null && !resources.isEmpty()) { 
            //Remove all ResultingChange elements
            removeContent(getChildren("ResultingResource", false));

            addContent(resources);
        }
        else {
            //Remove all ResultingChange elements
            removeContent(getChildren("ResultingResource", false));
        }
    }

    public void setSelectableCompositeUnits(Collection<CompositeUnit> compositeUnits) {
        Element selectableContent;

        if (isSetElement("SelectableContent")) {
            selectableContent = getChild("SelectableContent");
        }
        else {
            selectableContent = session.createDeploymentElement("SelectableContent");
        }
        
        if (compositeUnits != null && !compositeUnits.isEmpty()) {
            //Remove all CompositeUnit elements
            Collection<Element> compositeUnitNodeList = session.getChildren(selectableContent, "CompositeUnit");
            for (Element element : compositeUnitNodeList) {
                selectableContent.removeChild(element);
            }
            
            for (CompositeUnit compositeUnit : compositeUnits) {
                session.insertNode(selectableContent, (SPIDataObject) compositeUnit, SELECTABLE_CONTENT_TYPE);
            }

            setContent(selectableContent);
        }
        else {
            //Remove all CompositeUnit elements
            Collection<Element> compositeUnitNodeList = session.getChildren(selectableContent, "CompositeUnit");
            for (Element element : compositeUnitNodeList) {
                selectableContent.removeChild(element);
            }

            if (session.getChildren(selectableContent, "Features").isEmpty() &&
            		session.getChildren(selectableContent, "Groups").isEmpty() &&
            		session.getChildren(selectableContent, "CompositeUnit").isEmpty() &&
            		session.getChildren(selectableContent, "ConfigurationUnit").isEmpty() &&
            		session.getChildren(selectableContent, "ContainedPackage").isEmpty() &&
            		session.getChildren(selectableContent, "InstallableUnit").isEmpty()) {
                unSetElement("SelectableContent");
            }
        }
    }

    public void setSelectableConfigurationUnits(Collection<ConfigurationUnit> configurationUnits) {
        Element selectableContent;

        if (isSetElement("SelectableContent")) {
            selectableContent = getChild("SelectableContent");
        }
        else {
            selectableContent = session.createDeploymentElement("SelectableContent");
        }
        
        if (configurationUnits != null && !configurationUnits.isEmpty()) {
            //Remove all ConfigurationUnit elements
            Collection<Element> configurationUnitNodeList = session.getChildren(selectableContent, "ConfigurationUnit");
            for (Element element : configurationUnitNodeList) {
                selectableContent.removeChild(element);
            }
            
            for (ConfigurationUnit compositeUnit : configurationUnits) {
                session.insertNode(selectableContent, (SPIDataObject) compositeUnit, SELECTABLE_CONTENT_TYPE);
            }

            setContent(selectableContent);
        }
        else {
            //Remove all ConfigurationUnit elements
            Collection<Element> configurationUnitNodeList = session.getChildren(selectableContent, "ConfigurationUnit");
            for (Element element : configurationUnitNodeList) {
                selectableContent.removeChild(element);
            }

            if (session.getChildren(selectableContent, "Features").isEmpty() &&
            		session.getChildren(selectableContent, "Groups").isEmpty() &&
            		session.getChildren(selectableContent, "CompositeUnit").isEmpty() &&
            		session.getChildren(selectableContent, "ConfigurationUnit").isEmpty() &&
            		session.getChildren(selectableContent, "ContainedPackage").isEmpty() &&
            		session.getChildren(selectableContent, "InstallableUnit").isEmpty()) {
                unSetElement("SelectableContent");
            }
        }
    }

    public void setSelectableContainedPackages(Collection<ReferencedPackage> containedPackages) {
        Element selectableContent;

        if (isSetElement("SelectableContent")) {
            selectableContent = getChild("SelectableContent");
        }
        else {
            selectableContent = session.createDeploymentElement("SelectableContent");
        }
        
        if (containedPackages != null && !containedPackages.isEmpty()) {
            //Remove all ContainedPackage elements
            Collection<Element> containedPackageNodeList = session.getChildren(selectableContent, "ContainedPackage");
            for (Element element : containedPackageNodeList) {
                selectableContent.removeChild(element);
            }
            
            for (ReferencedPackage containedPackage : containedPackages) {
                session.insertNode(selectableContent, (SPIDataObject) containedPackage, SELECTABLE_CONTENT_TYPE);
            }

            setContent(selectableContent);
        }
        else {
            //Remove all ContainedPackage elements
            Collection<Element> containedPackageNodeList = session.getChildren(selectableContent, "ContainedPackage");
            for (Element element : containedPackageNodeList) {
                selectableContent.removeChild(element);
            }

            if (session.getChildren(selectableContent, "Features").isEmpty() &&
            		session.getChildren(selectableContent, "Groups").isEmpty() &&
            		session.getChildren(selectableContent, "CompositeUnit").isEmpty() &&
            		session.getChildren(selectableContent, "ConfigurationUnit").isEmpty() &&
            		session.getChildren(selectableContent, "ContainedPackage").isEmpty() &&
            		session.getChildren(selectableContent, "InstallableUnit").isEmpty()) {
                unSetElement("SelectableContent");
            }
        }
    }

    public void setSelectableInstallableUnits(Collection<InstallableUnit> installableUnits) {
        Element selectableContent;

        if (isSetElement("SelectableContent")) {
            selectableContent = getChild("SelectableContent");
        }
        else {
            selectableContent = session.createDeploymentElement("SelectableContent");
        }
        
        if (installableUnits != null && !installableUnits.isEmpty()) {
            //Remove all InstallableUnit elements
            Collection<Element> installableUnitNodeList = session.getChildren(selectableContent, "InstallableUnit");
            for (Element element : installableUnitNodeList) {
                selectableContent.removeChild(element);
            }
            
            for (InstallableUnit compositeUnit : installableUnits) {
                session.insertNode(selectableContent, (SPIDataObject) compositeUnit, SELECTABLE_CONTENT_TYPE);
            }

            setContent(selectableContent);
        }
        else {
            //Remove all InstallableUnit elements
            Collection<Element> installableUnitNodeList = session.getChildren(selectableContent, "InstallableUnit");
            for (Element element : installableUnitNodeList) {
                selectableContent.removeChild(element);
            }

            if (session.getChildren(selectableContent, "Features").isEmpty() &&
            		session.getChildren(selectableContent, "Groups").isEmpty() &&
            		session.getChildren(selectableContent, "CompositeUnit").isEmpty() &&
            		session.getChildren(selectableContent, "ConfigurationUnit").isEmpty() &&
            		session.getChildren(selectableContent, "ContainedPackage").isEmpty() &&
            		session.getChildren(selectableContent, "InstallableUnit").isEmpty()) {
                unSetElement("SelectableContent");
            }
        }
    }

    public Object clone() {
        return new CompositeInstallableImpl((Element)getElement().cloneNode(true), session);
    }
}