/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.MultiFeatureSelect;
import org.w3c.dom.Element;

public class MultiFeatureSelectImpl extends SPIDataObject implements MultiFeatureSelect {
	private static final String MULTI_SELECT_TYPE = "sdd-dd:MultiSelectType";

	public MultiFeatureSelectImpl(Element data, SPISessionImpl session) {
        super(data, session, MULTI_SELECT_TYPE);
    }

    public Collection<String> getFeatures() {
    	Collection<String> features = new ArrayList<String>();
    	Collection<Element> featureElements = getChildren("Feature");
    	
    	for (Element featureElement : featureElements) {
    		features.add(featureElement.getAttribute("featureRef"));
    	}
    	
    	return features;
    }

    public BigInteger getMaxSelections() {
    	BigInteger maxSelections = null;

    	if (isSetAttribute("maxSelections")) {
    		maxSelections = new BigInteger(getAttribute("maxSelections"));
    	}
    	
    	return maxSelections;
    }

    public BigInteger getMinSelections() {
    	BigInteger minSelections = null;

    	if (isSetAttribute("minSelections")) {
    		minSelections = new BigInteger(getAttribute("minSelections"));
    	}
    	
    	return minSelections;
    }

    public void setFeatures(Collection<String> featureRefs) {
        session.testCollectionParameter(featureRefs, 1, 2, -1);
        
        if (featureRefs == null) {
        	unSetElement("Feature");
        }
        else {
        	Collection<Element> featureElements = new ArrayList<Element>();
        	removeContent(getChildren("Feature", false));
        	
        	for (String featureRef : featureRefs) {
        		Element featureElement = session.createDeploymentElement("Feature");
        		featureElement.setAttribute("featureRef", featureRef);
        		featureElements.add(featureElement);
        	}
        	
        	addContent(featureElements);
        }
    }

    public void setMaxSelections(BigInteger maxSelections) {
    	if (maxSelections == null) {
    		unSetAttribute("maxSelections");
    	}
    	else {
    		setAttribute("maxSelections", maxSelections.toString());
    	}
    }

    public void setMinSelections(BigInteger minSelections) {
    	if (minSelections == null) {
    		unSetAttribute("minSelections");
    	}
    	else {
    		setAttribute("minSelections", minSelections.toString());
    	}
    }

    public Object clone() {
    	return new MultiFeatureSelectImpl((Element)getElement().cloneNode(true), session);
    }
}
