/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform;

import java.net.URI;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.IRootElement;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.artifacts.IContentSelector;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.artifacts.ITemplate;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IConstraint;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IDepthLimit;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IInstanceIdConstraint;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IItemReference;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IItemTemplate;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IOperator;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IPrefixMapping;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IPropertyId;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IPropertyValue;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IQuery;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IQueryInputArtifactFactory;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IRecordConstraint;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IRecordType;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IRelationshipEndpoint;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IRelationshipTemplate;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.ISelectedRecordType;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IXPathExpression;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.QueryInputArtifactFactory;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.ITransformerHandler;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IInstanceId;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.Attributes2;
import org.xml.sax.helpers.DefaultHandler;

public class QueryInputStreamHandler
extends DefaultHandler
implements ITransformerHandler {
    private IQuery query;
    private ITemplate currentTemplate;
    private String currentElementData;
    private IConstraint currentConstraint;
    private IContentSelector currentContentSelector;
    private IOperator currentOperator;
    private ISelectedRecordType currentSelectedRecordType;
    private IInstanceId currentInstanceId;
    private IPropertyValue currentPropertyValue;
    private IQueryInputArtifactFactory artifactFactory;
    private boolean relationshipTemplate;
    private boolean instanceIdConstraint;
    private boolean propertyValue;
    private boolean xpathExpression;
    private boolean contentSelector;

    public QueryInputStreamHandler(IQueryInputArtifactFactory artifactFactory) {
        this.artifactFactory = artifactFactory;
    }

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (!"http://cmdbf.org/schema/1-0-0/datamodel".equals(uri)) {
            return;
        }
        boolean temporaryFlag = false;
        if (this.propertyValue) {
            this.handlePropertyElements(uri, localName, name, attributes, true);
        } else if (this.xpathExpression) {
            this.handleXPathElements(uri, localName, name, attributes, true);
        } else if (this.contentSelector) {
            this.handleContentSelector(uri, localName, name, attributes, true);
        } else if ("query".equals(localName)) {
            this.query = this.getArtifactFactory().createQuery();
        } else if ("itemTemplate".equals(localName) || (temporaryFlag = "relationshipTemplate".equals(localName))) {
            if (temporaryFlag) {
                this.relationshipTemplate = true;
                this.currentTemplate = this.getArtifactFactory().createRelationshipTemplate(null);
            } else {
                this.currentTemplate = this.getArtifactFactory().createItemTemplate(null);
            }
            String id = attributes.getValue("id");
            this.currentTemplate.setId(id);
            String suppressFromResultValue = attributes.getValue("suppressFromResult");
            if (suppressFromResultValue != null && ((Attributes2)attributes).isSpecified("suppressFromResult")) {
                this.currentTemplate.setSuppressFromResult(Boolean.parseBoolean(suppressFromResultValue));
            }
        } else if (this.relationshipTemplate && "sourceTemplate".equals(localName)) {
            this.addEndpointItems(attributes, 0, localName);
        } else if (this.relationshipTemplate && "targetTemplate".equals(localName)) {
            this.addEndpointItems(attributes, 1, localName);
        } else if (this.relationshipTemplate && "depthLimit".equals(localName)) {
            int value;
            IItemReference element = this.getArtifactFactory().createItemReference();
            String referenceId = attributes.getValue("intermediateItemTemplate");
            element.setId(referenceId);
            element.setRef(this.query.getItemTemplate(referenceId));
            String maxItems = attributes.getValue("maxIntermediateItems");
            int n = value = QueryInputStreamHandler.isNumber(maxItems) ? Integer.parseInt(maxItems) : -1;
            if (value >= 0) {
                IDepthLimit depthLimit = this.getArtifactFactory().createDepthLimit();
                depthLimit.setIntermediateItemTemplate(element);
                depthLimit.setMaxIntermediateItems(value);
                ((IRelationshipTemplate)this.currentTemplate).setDepthLimit(depthLimit);
            }
        } else if ("instanceIdConstraint".equals(localName)) {
            this.instanceIdConstraint = true;
            this.currentConstraint = this.getArtifactFactory().createInstanceIdConstraint();
        } else if ("instanceId".equals(localName)) {
            this.currentInstanceId = this.getArtifactFactory().createInstanceId();
            ((IInstanceIdConstraint)this.currentConstraint).addInstanceId(this.currentInstanceId);
        } else if ("recordConstraint".equals(localName)) {
            this.currentConstraint = this.getArtifactFactory().createRecordConstraint();
        } else if ("propertyValue".equals(localName)) {
            this.propertyValue = true;
            IPropertyValue propertyValue = this.getArtifactFactory().createPropertyValue();
            String namespace = attributes.getValue("namespace");
            String locName = attributes.getValue("localName");
            propertyValue.setNamespace(CMDBfServicesUtil.createURI((String)namespace));
            propertyValue.setLocalName(locName);
            if (this.shouldRetrieveAttribute(attributes, "recordMetadata")) {
                String recordMetadata = attributes.getValue("recordMetadata");
                propertyValue.setMatchAny(Boolean.parseBoolean(recordMetadata));
            }
            if (this.shouldRetrieveAttribute(attributes, "matchAny")) {
                String matchAny = attributes.getValue("matchAny");
                propertyValue.setMatchAny(Boolean.parseBoolean(matchAny));
            }
            ((IRecordConstraint)this.currentConstraint).addPropertyValue(propertyValue);
            this.currentPropertyValue = propertyValue;
        } else if ("xpathExpression".equals(localName)) {
            this.xpathExpression = true;
            URI dialectURI = CMDBfServicesUtil.createURI((String)attributes.getValue("dialect"));
            this.currentConstraint = this.getArtifactFactory().createXPathExpression(dialectURI);
        } else if ("recordType".equals(localName)) {
            IRecordType recordType = this.getArtifactFactory().createRecordType();
            String namespace = attributes.getValue("namespace");
            String locName = attributes.getValue("localName");
            recordType.setNamespace(CMDBfServicesUtil.createURI((String)namespace));
            recordType.setLocalName(locName);
            ((IRecordConstraint)this.currentConstraint).addRecordType(recordType);
        } else if ("contentSelector".equals(localName)) {
            this.contentSelector = true;
            this.currentContentSelector = this.getArtifactFactory().createContentSelector();
            if (this.shouldRetrieveAttribute(attributes, "matchedRecords")) {
                String matchedRecords = attributes.getValue("matchedRecords");
                this.currentContentSelector.setMatchedRecords(Boolean.parseBoolean(matchedRecords));
            }
        }
    }

    private static boolean isNumber(String str) {
        if (str == null) {
            return false;
        }
        int i = 0;
        int charCount = str.length();
        while (i < charCount) {
            if (!Character.isDigit(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return str.length() > 0;
    }

    private void addEndpointItems(Attributes attributes, int relationshipType, String localName) {
        String max;
        String min;
        IRelationshipEndpoint element = this.getArtifactFactory().createRelationshipEndpoint(relationshipType);
        String referenceId = attributes.getValue("ref");
        element.setId(referenceId);
        IItemTemplate template = this.query.getItemTemplate(referenceId);
        if (template != null) {
            element.setRef(template);
        }
        if ((min = attributes.getValue("minimum")) != null) {
            element.setMinimum(Integer.valueOf(min));
        }
        if ((max = attributes.getValue("maximum")) != null) {
            element.setMaximum(Integer.valueOf(max));
        }
        if (this.currentTemplate != null) {
            if ("sourceTemplate".equals(localName)) {
                ((IRelationshipTemplate)this.currentTemplate).setSourceElement(element);
            } else {
                ((IRelationshipTemplate)this.currentTemplate).setTargetElement(element);
            }
        }
    }

    private boolean shouldRetrieveAttribute(Attributes attributes, String attributeName) {
        int attributeIndex = attributes.getIndex(attributeName);
        return attributeIndex != -1 && (!(attributes instanceof Attributes2) || ((Attributes2)attributes).isSpecified(attributeIndex));
    }

    private void handleInstanceIdElements(String uri, String localName, String name, boolean open) {
        if (!open) {
            if ("mdrId".equals(localName)) {
                this.currentInstanceId.setMdrId(this.currentElementData);
            } else if ("localId".equals(localName)) {
                this.currentInstanceId.setLocalId(this.currentElementData);
            }
        }
    }

    private void handleContentSelector(String uri, String localName, String name, Attributes attributes, boolean open) {
        if (open) {
            if ("selectedRecordType".equals(localName)) {
                ISelectedRecordType recordType = this.getArtifactFactory().createSelectedRecordType();
                String namespace = attributes.getValue("namespace");
                String locName = attributes.getValue("localName");
                recordType.setNamespace(CMDBfServicesUtil.createURI((String)namespace));
                recordType.setLocalName(locName);
                this.currentSelectedRecordType = recordType;
                this.currentContentSelector.addSelectedRecordType(recordType);
            } else if ("selectedProperty".equals(localName)) {
                IPropertyId property = this.getArtifactFactory().createPropertyId();
                String namespace = attributes.getValue("namespace");
                String locName = attributes.getValue("localName");
                property.setNamespace(CMDBfServicesUtil.createURI((String)namespace));
                property.setLocalName(locName);
                this.currentSelectedRecordType.addSelectedProperty(property);
            }
        }
    }

    private void handleXPathElements(String uri, String localName, String name, Attributes attributes, boolean open) {
        if (open) {
            if ("prefixMapping".equals(localName)) {
                IPrefixMapping mapping = this.getArtifactFactory().createPrefixMapping();
                mapping.setPrefix(attributes.getValue("prefix"));
                mapping.setNamespace(CMDBfServicesUtil.createURI((String)attributes.getValue("namespace")));
                ((IXPathExpression)this.currentConstraint).addPrefixMapping(mapping);
            }
        } else if ("expression".equals(localName)) {
            ((IXPathExpression)this.currentConstraint).setExpression(this.currentElementData);
        }
    }

    private void handlePropertyElements(String uri, String localName, String name, Attributes attributes, boolean open) {
        if (open) {
            if ("less".equals(localName)) {
                this.createCurrentOperator(attributes, 2);
            } else if ("lessOrEqual".equals(localName)) {
                this.createCurrentOperator(attributes, 4);
            } else if ("greater".equals(localName)) {
                this.createCurrentOperator(attributes, 1);
            } else if ("greaterOrEqual".equals(localName)) {
                this.createCurrentOperator(attributes, 3);
            } else if ("equal".equals(localName)) {
                this.createCurrentStringOperator(attributes, 0);
            } else if ("like".equals(localName)) {
                this.createCurrentStringOperator(attributes, 5);
            } else if ("contains".equals(localName)) {
                this.createCurrentStringOperator(attributes, 6);
            } else if ("isNull".equals(localName)) {
                this.currentOperator = this.getArtifactFactory().createOperator(7);
                if (this.shouldRetrieveAttribute(attributes, "negate")) {
                    String negateString = attributes.getValue("negate");
                    this.currentOperator.setNegate(Boolean.parseBoolean(negateString));
                }
            }
        } else if (this.isComparisonSelector(localName)) {
            this.currentOperator.setValue(this.currentElementData);
            this.currentPropertyValue.addOperator(this.currentOperator);
        }
    }

    private void createCurrentOperator(Attributes attributes, int type) {
        this.currentOperator = this.getArtifactFactory().createOperator(type);
        if (this.shouldRetrieveAttribute(attributes, "negate")) {
            String negateString = attributes.getValue("negate");
            this.currentOperator.setNegate(Boolean.parseBoolean(negateString));
        }
    }

    private void createCurrentStringOperator(Attributes attributes, int type) {
        this.createCurrentOperator(attributes, type);
        if (this.shouldRetrieveAttribute(attributes, "caseSensitive")) {
            String caseSensitiveString = attributes.getValue("caseSensitive");
            this.currentOperator.setCaseSensitive(Boolean.parseBoolean(caseSensitiveString));
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        if (!"http://cmdbf.org/schema/1-0-0/datamodel".equals(uri)) {
            return;
        }
        if ("itemTemplate".equals(localName)) {
            this.query.addItemTemplate((IItemTemplate)this.currentTemplate);
            this.currentTemplate = null;
        } else if (this.relationshipTemplate && "relationshipTemplate".equals(localName)) {
            this.relationshipTemplate = false;
            this.query.addRelationshipTemplate((IRelationshipTemplate)this.currentTemplate);
            this.currentTemplate = null;
        } else if (this.instanceIdConstraint && "instanceId".equals(localName)) {
            this.currentInstanceId = null;
        } else if (this.instanceIdConstraint && "instanceIdConstraint".equals(localName)) {
            this.instanceIdConstraint = false;
            this.currentTemplate.setInstanceIdConstraint((IInstanceIdConstraint)this.currentConstraint);
            this.currentConstraint = null;
        } else if ("xpathExpression".equals(localName)) {
            this.xpathExpression = false;
            this.currentTemplate.addXpathExpression((IXPathExpression)this.currentConstraint);
            this.currentConstraint = null;
        } else if ("recordConstraint".equals(localName)) {
            this.currentTemplate.addRecordConstraint((IRecordConstraint)this.currentConstraint);
            this.currentConstraint = null;
        } else if (this.propertyValue && "propertyValue".equals(localName)) {
            this.propertyValue = false;
            this.currentPropertyValue = null;
        } else if (this.contentSelector && "contentSelector".equals(localName)) {
            this.contentSelector = false;
            this.currentTemplate.setContentSelector(this.currentContentSelector);
            this.currentContentSelector = null;
        } else if ("isNull".equals(localName)) {
            this.currentPropertyValue.addOperator(this.currentOperator);
        } else if (this.instanceIdConstraint) {
            this.handleInstanceIdElements(uri, localName, name, false);
        } else if (this.propertyValue) {
            this.handlePropertyElements(uri, localName, name, null, false);
        } else if (this.xpathExpression) {
            this.handleXPathElements(uri, localName, name, null, false);
        }
        this.currentElementData = null;
    }

    private boolean isComparisonSelector(String name) {
        return "equal".equals(name) || "contains".equals(name) || "like".equals(name) || "greater".equals(name) || "greaterOrEqual".equals(name) || "less".equals(name) || "lessOrEqual".equals(name);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String tempData = new String(ch, start, length).trim();
        this.currentElementData = this.currentElementData == null ? tempData : String.valueOf(this.currentElementData) + tempData;
    }

    public IRootElement getResult() {
        return this.query;
    }

    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    protected IQueryInputArtifactFactory getArtifactFactory() {
        if (this.artifactFactory == null) {
            this.artifactFactory = QueryInputArtifactFactory.getInstance();
        }
        return this.artifactFactory;
    }
}

