/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.internal.dr.drs.service.handler.common;

import java.util.Enumeration;
import java.util.ResourceBundle;

import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.LoggingEvent;

public class Log4JWrapper implements ILogger  {
	protected Logger logger;

	public Log4JWrapper(Class clazz){
		logger = logger.getLogger(clazz);
	}
	
	public Log4JWrapper(String name){
		logger = logger.getLogger(name);
	}
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#addAppender(org.apache.log4j.Appender)
	 */
	public void addAppender(Appender newAppender) {
		logger.addAppender(newAppender);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#assertLog(boolean, java.lang.String)
	 */
	public void assertLog(boolean assertion, String msg) {
		logger.assertLog(assertion, msg);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#callAppenders(org.apache.log4j.spi.LoggingEvent)
	 */
	public void callAppenders(LoggingEvent event) {
		logger.callAppenders(event);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#debug(java.lang.Object, java.lang.Throwable)
	 */
	public void debug(Object message, Throwable t) {
		logger.debug(message, t);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#debug(java.lang.Object)
	 */
	public void debug(Object message) {
		logger.debug(message);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#equals(java.lang.Object)
	 */
	public boolean equals(Object arg0) {
		return logger.equals(arg0);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#error(java.lang.Object, java.lang.Throwable)
	 */
	public void error(Object message, Throwable t) {
		logger.error(message, t);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#error(java.lang.Object)
	 */
	public void error(Object message) {
		logger.error(message);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#fatal(java.lang.Object, java.lang.Throwable)
	 */
	public void fatal(Object message, Throwable t) {
		logger.fatal(message, t);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#fatal(java.lang.Object)
	 */
	public void fatal(Object message) {
		logger.fatal(message);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#getAdditivity()
	 */
	public boolean getAdditivity() {
		return logger.getAdditivity();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#getAllAppenders()
	 */
	public Enumeration getAllAppenders() {
		return logger.getAllAppenders();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#getAppender(java.lang.String)
	 */
	public Appender getAppender(String name) {
		return logger.getAppender(name);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#getChainedPriority()
	 */
	public Priority getChainedPriority() {
		return logger.getChainedPriority();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#getEffectiveLevel()
	 */
	public Level getEffectiveLevel() {
		return logger.getEffectiveLevel();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#getHierarchy()
	 */
	public LoggerRepository getHierarchy() {
		return logger.getHierarchy();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#getLevel()
	 */
	public final Level getLevel() {
		return logger.getLevel();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#getLoggerRepository()
	 */
	public LoggerRepository getLoggerRepository() {
		return logger.getLoggerRepository();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#getName()
	 */
	public final String getName() {
		return logger.getName();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#getParent()
	 */
	public final Category getParent() {
		return logger.getParent();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#getPriority()
	 */
	public final Level getPriority() {
		return logger.getPriority();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#getResourceBundle()
	 */
	public ResourceBundle getResourceBundle() {
		return logger.getResourceBundle();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#hashCode()
	 */
	public int hashCode() {
		return logger.hashCode();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#info(java.lang.Object, java.lang.Throwable)
	 */
	public void info(Object message, Throwable t) {
		logger.info(message, t);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#info(java.lang.Object)
	 */
	public void info(Object message) {
		logger.info(message);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#isAttached(org.apache.log4j.Appender)
	 */
	public boolean isAttached(Appender appender) {
		return logger.isAttached(appender);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#isDebugEnabled()
	 */
	public boolean isDebugEnabled() {
		return logger.isDebugEnabled();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#isEnabledFor(org.apache.log4j.Priority)
	 */
	public boolean isEnabledFor(Priority level) {
		return logger.isEnabledFor(level);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#isInfoEnabled()
	 */
	public boolean isInfoEnabled() {
		return logger.isInfoEnabled();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#isTraceEnabled()
	 */
	public boolean isTraceEnabled() {
		return logger.isTraceEnabled();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#l7dlog(org.apache.log4j.Priority, java.lang.String, java.lang.Object[], java.lang.Throwable)
	 */
	public void l7dlog(Priority priority, String key, Object[] params,
			Throwable t) {
		logger.l7dlog(priority, key, params, t);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#l7dlog(org.apache.log4j.Priority, java.lang.String, java.lang.Throwable)
	 */
	public void l7dlog(Priority priority, String key, Throwable t) {
		logger.l7dlog(priority, key, t);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#log(org.apache.log4j.Priority, java.lang.Object, java.lang.Throwable)
	 */
	public void log(Priority priority, Object message, Throwable t) {
		logger.log(priority, message, t);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#log(org.apache.log4j.Priority, java.lang.Object)
	 */
	public void log(Priority priority, Object message) {
		logger.log(priority, message);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#log(java.lang.String, org.apache.log4j.Priority, java.lang.Object, java.lang.Throwable)
	 */
	public void log(String callerFQCN, Priority level, Object message,
			Throwable t) {
		logger.log(callerFQCN, level, message, t);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#removeAllAppenders()
	 */
	public void removeAllAppenders() {
		logger.removeAllAppenders();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#removeAppender(org.apache.log4j.Appender)
	 */
	public void removeAppender(Appender appender) {
		logger.removeAppender(appender);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#removeAppender(java.lang.String)
	 */
	public void removeAppender(String name) {
		logger.removeAppender(name);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#setAdditivity(boolean)
	 */
	public void setAdditivity(boolean additive) {
		logger.setAdditivity(additive);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#setLevel(org.apache.log4j.Level)
	 */
	public void setLevel(Level level) {
		logger.setLevel(level);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#setPriority(org.apache.log4j.Priority)
	 */
	public void setPriority(Priority priority) {
		logger.setPriority(priority);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#setResourceBundle(java.util.ResourceBundle)
	 */
	public void setResourceBundle(ResourceBundle bundle) {
		logger.setResourceBundle(bundle);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#toString()
	 */
	public String toString() {
		return logger.toString();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#trace(java.lang.Object, java.lang.Throwable)
	 */
	public void trace(Object message, Throwable t) {
		logger.trace(message, t);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#trace(java.lang.Object)
	 */
	public void trace(Object message) {
		logger.trace(message);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#warn(java.lang.Object, java.lang.Throwable)
	 */
	public void warn(Object message, Throwable t) {
		logger.warn(message, t);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger#warn(java.lang.Object)
	 */
	public void warn(Object message) {
		logger.warn(message);
	}
}
