/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.databuilders;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import org.apache.xerces.xs.XSElementDeclaration;
import org.eclipse.cosmos.rm.internal.validation.artifacts.IdentityConstraintStructure;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.internal.validation.databuilders.IdentityConstraintDataBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityConstraintUtil {
    public static List<IdentityConstraintStructure.IdentityConstraint> retrieveConstraints(XSElementDeclaration elementDeclaration, NamespaceContext namespaceContext) {
        ArrayList<IdentityConstraintStructure.IdentityConstraint> identityConstraints = new ArrayList<IdentityConstraintStructure.IdentityConstraint>();
        if (elementDeclaration == null) {
            return identityConstraints;
        }
        Node[] nodes = SMLValidatorUtil.retrieveAnnotation(elementDeclaration, "http://www.w3.org/ns/sml", IdentityConstraintDataBuilder.IDENTITY_CONSTRAINTS);
        int i = 0;
        while (i < nodes.length) {
            IdentityConstraintStructure.IdentityConstraint constraint = new IdentityConstraintStructure.IdentityConstraint();
            constraint.setRef(IdentityConstraintUtil.retrieveAttribute(nodes[i], "http://www.w3.org/ns/sml", "ref"));
            constraint.setName(IdentityConstraintUtil.retrieveAttribute(nodes[i], "http://www.w3.org/ns/sml", "name"));
            Node[] fields = SMLValidatorUtil.findNodes(nodes[i], "http://www.w3.org/ns/sml", "field");
            Node[] selector = SMLValidatorUtil.findNodes(nodes[i], "http://www.w3.org/ns/sml", "selector");
            String localName = nodes[i].getLocalName();
            byte type = "key".equals(localName) ? (byte)0 : ("keyref".equals(localName) ? (byte)1 : 2);
            constraint.setNamespaceContext(namespaceContext);
            constraint.setType(type);
            int j = 0;
            while (j < fields.length) {
                constraint.addField(IdentityConstraintUtil.retrieveAttribute(fields[j], "http://www.w3.org/ns/sml", "xpath"));
                ++j;
            }
            if (selector != null && selector.length > 0) {
                constraint.setSelector(IdentityConstraintUtil.retrieveAttribute(selector[0], "http://www.w3.org/ns/sml", "xpath"));
            }
            constraint.setRefer(IdentityConstraintUtil.retrieveAttribute(nodes[i], "http://www.w3.org/ns/sml", "refer"));
            constraint.setNamespace(elementDeclaration.getNamespace());
            identityConstraints.add(constraint);
            ++i;
        }
        identityConstraints.addAll(IdentityConstraintUtil.retrieveConstraints(elementDeclaration.getSubstitutionGroupAffiliation(), namespaceContext));
        return identityConstraints;
    }

    public static String retrieveAttribute(Node node, String uri, String localName) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return null;
        }
        Node attribute = attributes.getNamedItem(localName);
        attribute = attribute == null ? attributes.getNamedItemNS(uri, localName) : attribute;
        return attribute == null ? null : attribute.getNodeValue();
    }

    public static String lookupNamespace(XSElementDeclaration elementDeclaration, String prefix) {
        Document document = SMLValidatorUtil.createDocument();
        elementDeclaration.getAnnotation().writeAnnotation((Object)document, (short)3);
        NamedNodeMap attributes = document.getFirstChild().getAttributes();
        Node namespace = attributes.getNamedItem("xmlns:" + prefix);
        String result = null;
        return namespace == null || (result = namespace.getNodeValue()) == null ? "" : result;
    }
}

