/**********************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.validation.databuilders;

import javax.xml.namespace.QName;

import org.eclipse.cosmos.rm.internal.validation.artifacts.ConstraintNode;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ElementDeclarationCollection;
import org.eclipse.cosmos.rm.internal.validation.artifacts.GroupDeclaration;
import org.eclipse.cosmos.rm.internal.validation.artifacts.GroupDeclarationCollection;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidatorUtil;

/**
 * Contains state-less helper methods commonly used by 
 * data builders.
 * 
 * @author Ali Mehregani
 */
public class DataBuilderUtil
{
	/**
	 * Retrieves the group declaration that the reference passed
	 * in refers to.
	 * 
	 * @param reference The reference to be resolved
	 * @return The result of resolving the reference
	 */
	public static GroupDeclaration retrieveGroup(QName reference)
	{
		GroupDeclarationCollection groupCollection = (GroupDeclarationCollection)SMLValidatorUtil.retrieveDataStructure(GroupDeclarationBuilder.ID);
		return groupCollection.get(reference);		
	}

	
	/**
	 * Retrieves the element declaration that the reference passed
	 * in refers to.
	 * 
	 * @param reference The reference to be resolved
	 * @return The result of resolving 
	 */
	public static ConstraintNode retrieveElement(QName reference)
	{
		ElementDeclarationCollection globalTargetSchemaNodes = (ElementDeclarationCollection)SMLValidatorUtil.retrieveDataStructure(ElementDeclarationBuilder.ID);
		return globalTargetSchemaNodes.get(reference);
	}
}
