/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.examples.common.validation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.validation.SDDManagerImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.validation.util.ValidatorUtils;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.validation.exception.XMLValidationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SDDManager_Sample {
    private static final String FSEP = System.getProperty("file.separator");
    private static final String filesPath = "src" + FSEP + "org" + FSEP + "eclipse" + FSEP + "cosmos" + FSEP + "me" + FSEP + "internal" + FSEP + "deployment" + FSEP + "sdd" + FSEP + "examples" + FSEP + "common" + FSEP + "validation" + FSEP;
    private static final File deploymentDescriptor = new File(String.valueOf(filesPath) + "DeploymentDescriptor.xml");
    private static final File packageDescriptor = new File(String.valueOf(filesPath) + "PackageDescriptor.xml");

    public static void main(String[] args) {
        SDDManager_Sample.prepFiles();
        SDDManagerImpl mySDDManager = new SDDManagerImpl();
        Document ddDocument = null;
        try {
            ddDocument = mySDDManager.addDescriptorFromFile(deploymentDescriptor);
            mySDDManager.addDescriptorFromFile(packageDescriptor);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (XMLValidationException e) {
            e.printStackTrace();
            System.exit(1);
        }
        Element completionElement = ValidatorUtils.findElement(ddDocument, "Completion");
        completionElement.getParentNode().removeChild(completionElement);
        try {
            mySDDManager.writeAllDescriptors(true);
        }
        catch (XMLValidationException e) {
            System.err.println("Error validating a changed descriptor:\n");
            e.printStackTrace();
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void prepFiles() {
        File ddOriginal = new File(String.valueOf(filesPath) + "DeploymentDescriptor.xml_Original");
        File pdOriginal = new File(String.valueOf(filesPath) + "PackageDescriptor.xml_Original");
        try {
            FileChannel ddSrcChannel = new FileInputStream(ddOriginal).getChannel();
            FileChannel ddDestChannel = new FileOutputStream(deploymentDescriptor).getChannel();
            ddDestChannel.transferFrom(ddSrcChannel, 0L, ddSrcChannel.size());
            FileChannel pdSrcChannel = new FileInputStream(pdOriginal).getChannel();
            FileChannel pdDestChannel = new FileOutputStream(packageDescriptor).getChannel();
            pdDestChannel.transferFrom(pdSrcChannel, 0L, pdSrcChannel.size());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

