/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.artifact;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;

/**
 * Artifact arguments consist of a required name and an optional corresponding
 * value.
 *
 */
public class ArtifactArgument {
    private final String name;
    private final String value;
    private final Boolean required;
    
    public ArtifactArgument(String name, String value, Boolean required) {
        if (name == null) {
            throw new InvalidInputException(1,InvalidInputException.NULL_ARGUMENT);
        }
        
        this.name = name;
        this.value = value;
        this.required = required;
    }

    public String getName() {
        return name;
    }

    public String getValue() {
        return value;
    }
    
    public Boolean getRequired() {
        return required;
    }
}
