/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.NameableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition.ConditionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.Condition;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Completion;
import org.w3c.dom.Element;

public class CompletionImpl extends NameableObject implements Completion {
	private static final String COMPLETION_TYPE = "sdd-dd:CompletionType";
	
	public CompletionImpl(Element data, SPISessionImpl session)	{
		super(data, session, COMPLETION_TYPE);
	}

	public Condition getCondition() {
		Condition c = null;
		
		if (isSetElement("Condition")) {
			c = new ConditionImpl(getChild("Condition"), session);
		}

		return c;
	}

    public Collection<String> getCompletionOperations() {
        Collection<String> operations = new ArrayList<String>();
        
        if (isSetAttribute("operation")) {
            StringTokenizer operationTokenizer = new StringTokenizer(getAttribute("operation"));
            
            while (operationTokenizer.hasMoreTokens()) {
                operations.add(operationTokenizer.nextToken());
            }
        }
        
        return operations;
    }

	public String getCompletionResourceReference() {
	    return getAttribute("resourceRef");
	}

	public String getCompletionType() {
	    return getAttribute("type");
	}

    public void setCompletionOperations(Collection<String> operations) {
        if (operations == null || operations.isEmpty()) {
            unSetAttribute("operation");
        }
        else {
            String operationString = "";
            // TODO check for enum value match
            for (String operation : operations) {
                operationString += operation + " ";
            }
            
            setAttribute("operation", operationString.trim());
        }
    }

	public void setCompletionResourceReference(String completionResourceReference) {
		session.testParameter(completionResourceReference, 1, null);

		setAttribute("resourceRef", completionResourceReference);
	}

	public void setCompletionType(String completionType) {
		session.testParameter(completionType, 1, null);

		setAttribute("type", completionType);
	}
	
	public void setCondition(Condition condition) {
		if (condition == null) {
		    unSetElement("Condition");
		}
		else {
	        setContent((SPIDataObject) condition);
		}
	}

	public Object clone() {
		Element copy = (Element) getElement().cloneNode(true);
		Completion duplicate = new CompletionImpl(copy, session);

		return duplicate;
	}
}