/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ContentSelectionFeature;
import org.w3c.dom.Element;

public class ContentSelectionFeatureImpl extends SPIDataObject implements ContentSelectionFeature {
	private static final String CONTENT_SELECTION_FEATURE_TYPE = "sdd-dd:ContentSelectionFeatureType";
    
    public ContentSelectionFeatureImpl(Element dataObject, SPISessionImpl session) {
        super(dataObject, session, CONTENT_SELECTION_FEATURE_TYPE);
    }

    public String getFeature() {
        return getElement().getTextContent();
    }

    public String getSelections() {
        return getAttribute("selections");
    }

    public void setFeature(String feature) {
        session.testParameter(feature, 1, null);

        getElement().setTextContent(feature);
    }

    public void setSelections(String selections) {
        if (selections == null) {
        	unSetAttribute("selections");
        }
        else {
            setAttribute("selections", selections);
        }
    }

    public Object clone() {
    	return new ContentSelectionFeatureImpl((Element)getElement().cloneNode(true), session);
    }
}
