/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/

package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.Collection;
import java.util.Iterator;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.PackageContent;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.CompositeInstallable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ConstrainedResource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ResultingChange;

public class ConstrainedResourceType {
	
	
	public static boolean equals( ConstrainedResource resource1, ConstrainedResource resource2){

		if (ResourceType.equals(Util.resolveResourceRef(resource1.getResourceRef()), Util.resolveResourceRef(resource2.getResourceRef())))
			if  (resource1.getConstraintType().equalsIgnoreCase(resource2.getConstraintType()))
				return true;

		return false;
	}
	
	public static boolean equals(Collection <ConstrainedResource> resources1, Collection <ConstrainedResource> resources2)
	{		
		Iterator <ConstrainedResource> iter1 = resources1.iterator();
		
		while (iter1.hasNext())
		{
			ConstrainedResource resource1 = iter1.next();
			boolean match = false;
			Iterator <ConstrainedResource> iter2 = resources2.iterator();
			
			while ((iter2.hasNext())||(!match))
			{
				ConstrainedResource resource2 = iter2.next();
				if (equals(resource1,resource2))
				{
					match = true;
				}
			}
			if (!match)
				return false;			
		}
			
		return true;
	}

}
