/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.DeploymentDescriptor;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ReferencedPackage;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.CompositeInstallable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.CompositeUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.InstallableUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.LocalizationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ConfigurationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.MultiFeatureSelect;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ResultingResource;



public class MultiSelectType {
	
	
	
	public static MultiFeatureSelect merge(MultiFeatureSelect mfs1, MultiFeatureSelect mfs2)
	{
		MultiFeatureSelect finalRps = (MultiFeatureSelect) mfs1.clone();
		Collection <String> newFeatures = new ArrayList <String> ();
		newFeatures.addAll(mfs1.getFeatures());
		newFeatures.addAll(mfs2.getFeatures());
		finalRps.setFeatures(newFeatures);
		if (mfs2.getMaxSelections().compareTo(mfs1.getMaxSelections())>0)
			finalRps.setMaxSelections(mfs2.getMaxSelections());
		if (mfs2.getMinSelections().compareTo(mfs1.getMinSelections())<0)
			finalRps.setMinSelections(mfs2.getMinSelections());
		
		return finalRps;
	}
	
	

	
}
