/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.internal.dr.drs.service.handler.common;

import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IOutputterParameters;

public class OutputterParameters implements IOutputterParameters {
	protected String description = ""; //$NON-NLS-1$
	protected String name = ""; //$NON-NLS-1$
	protected byte type = REQUIRED_TYPE;
	
	public OutputterParameters(String name) {
		super();
		this.name = name;	
	}
	
	public OutputterParameters(String name, byte type) {
		super();
		this.name = name;
		this.type = type;
	}
	public OutputterParameters(String description, String name) {
		super();
		this.description = description;
		this.name = name;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IOutputterParameters#getDescription()
	 */
	public String getDescription() {
		return description;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IOutputterParameters#setDescription(java.lang.String)
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IOutputterParameters#getName()
	 */
	public String getName() {
		return name;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IOutputterParameters#setName(java.lang.String)
	 */
	public void setName(String name) {
		this.name = name;
	}
	public byte getType() {
		return type;
	}
	public void setType(byte type) {
		this.type = type;
	}
}
