/*
* Copyright (c) 2005-2008 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.dc.internal.stat.datamgr.client;

import java.util.ArrayList;
import java.util.Date;

import javax.xml.namespace.QName;

public class StatisticalTuple {
	
	private static final StatisticalObservation[] EMPTY_OBSERVATION_LIST = {};
	
	private Date timeStamp;
	private ArrayList<StatisticalObservation> observationList = new ArrayList<StatisticalObservation>(); 

	public StatisticalTuple(){
	}
	
	public void add(StatisticalObservation stat){
		observationList.add(stat);
	}
	
	public void clear(){
		observationList.clear();
	}
	
	public void setTimeStamp(long time){
		timeStamp = new Date(time);
	}
	
	public void setTimeStamp(Date timeStamp){
		this.timeStamp = timeStamp;
	}

	public Date getTimeStamp(){
		return timeStamp;
	}
	
	public StatisticalObservation[] getObservations(){
		return observationList.toArray(EMPTY_OBSERVATION_LIST);
	}
	
	public String toString(){
		StringBuffer buffer = new StringBuffer();
		buffer.append(this.getTimeStamp());
		buffer.append(" (");
		for(StatisticalObservation ob : observationList){
			buffer.append(ob.toString());
			buffer.append(" ");
		}
		
		buffer.append(")");
		return buffer.toString();
	}


}
