/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.provisional.cmdbf.services.deregistration.transform;

import java.io.StringWriter;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.IRootElement;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.deregistration.transform.input.artifacts.DeregisterInputArtifactFactory;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.deregistration.transform.input.artifacts.IDeregisterInputArtifactFactory;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.deregistration.transform.input.artifacts.IDeregisterRequest;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.ITransformerHandler;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IInstanceId;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IItem;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IRelationship;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DeregistrationInputStreamHandler
extends DefaultHandler
implements ITransformerHandler {
    private IDeregisterRequest request;
    private String currentElementData;
    private IInstanceId currentInstanceId;
    private boolean inItemIdList = false;
    private IDeregisterInputArtifactFactory artifactFactory;

    public DeregistrationInputStreamHandler(IDeregisterInputArtifactFactory artifactFactory) {
        this.artifactFactory = artifactFactory;
    }

    public DeregistrationInputStreamHandler() {
    }

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (!"http://cmdbf.org/schema/1-0-0/datamodel".equals(uri)) {
            return;
        }
        if ("deregisterRequest".equals(localName)) {
            this.request = this.getArtifactFactory().createDeregisterRequest();
        } else if ("itemIdList".equals(localName)) {
            this.inItemIdList = true;
        } else if ("instanceId".equals(localName)) {
            this.currentInstanceId = this.getArtifactFactory().createInstanceId();
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        if (!"http://cmdbf.org/schema/1-0-0/datamodel".equals(uri)) {
            return;
        }
        if ("mdrId".equals(localName)) {
            if (this.currentInstanceId != null) {
                this.currentInstanceId.setMdrId(this.currentElementData);
            } else {
                this.request.setMdrId(CMDBfServicesUtil.createURI((String)this.currentElementData));
            }
            this.currentElementData = null;
        } else if ("localId".equals(localName)) {
            this.currentInstanceId.setLocalId(this.currentElementData);
            this.currentElementData = null;
        } else if ("instanceId".equals(localName)) {
            if (this.inItemIdList) {
                IItem item = this.getArtifactFactory().createItem();
                item.addInstanceId(this.currentInstanceId);
                this.request.addItem(item);
            } else {
                IRelationship relationship = this.getArtifactFactory().createRelationship();
                relationship.addInstanceId(this.currentInstanceId);
                this.request.addRelationship(relationship);
            }
            this.currentInstanceId = null;
        } else if ("itemIdList".equals(localName)) {
            this.inItemIdList = false;
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String tempData = new String(ch, start, length).trim();
        if (this.currentElementData == null) {
            this.currentElementData = tempData;
        } else {
            StringWriter tempWriter = new StringWriter();
            tempWriter.write(tempData);
            this.currentElementData = String.valueOf(this.currentElementData) + tempWriter.toString();
        }
    }

    public IDeregisterRequest getRequest() {
        return this.request;
    }

    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    public IRootElement getResult() {
        return this.getRequest();
    }

    public IDeregisterInputArtifactFactory getArtifactFactory() {
        if (this.artifactFactory == null) {
            this.artifactFactory = DeregisterInputArtifactFactory.getInstance();
        }
        return this.artifactFactory;
    }
}

