/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.repository.application.impl;

import org.eclipse.cosmos.rm.internal.repository.ISMLRepositoryConstants;
import org.eclipse.cosmos.rm.internal.repository.SMLRepositoryUtil;
import org.eclipse.cosmos.rm.internal.repository.application.ISMLResourceBase;
import org.eclipse.cosmos.rm.internal.repository.resource.SMLDocumentFragment;
import org.w3c.dom.Node;

/**
 * An abstract SML fragment
 * 
 * @author Ali Mehregani
 */
public abstract class AbstractSMLFragment extends SMLDocumentFragment implements ISMLResourceBase
{	
	/**
	 * Returns the node that will be used as the context.
	 * 
	 * @return The root node
	 */
	protected abstract Node getRootNode();
	
	
	/**
	 * @see org.eclipse.cosmos.rm.internal.repository.application.ISMLResourceBase#retrieveName()
	 */
	public String retrieveName()
	{
		return SMLRepositoryUtil.retrieveRootAttribute(getRootNode(), null, ISMLRepositoryConstants.NAME_ATTRIBUTE);
	}
	
	
	/**
	 * @see org.eclipse.cosmos.rm.internal.repository.application.ISMLResourceBase#retrieveDisplayName()
	 */
	public String retrieveDisplayName()
	{
		return SMLRepositoryUtil.retrieveRootAttribute(getRootNode(), null, ISMLRepositoryConstants.DISPLAY_NAME_ATTRIBUTE);
	}
	
	
	/**
	 * @see org.eclipse.cosmos.rm.internal.repository.application.ISMLResourceBase#retrieveDescription()
	 */
	public String retrieveDescription()
	{
		return SMLRepositoryUtil.retrieveRootAttribute(getRootNode(), null, ISMLRepositoryConstants.DESCRIPTION_ATTRIBUTE);
	}
}
