/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.repository.operations;

/**
 * An operation event is used to notify listeners of events that 
 * interrupt the normal flow of an operation.
 * 
 * @author David Whiteman
 * @author Ali Mehregani
 */
public class OperationEvent
{	
	/**
	 * The overwrite operation event.  The operation is 
	 * about to overwrite a file that already exists.  
	 * Clients can use the 'doit' flag to indicate whether
	 * the operation should continue.
	 */
	public static final byte TYPE_OVERWRITE = 0x00;
		
	/**
	 * This type of an event is used to indicate that 
	 * a required structure for the import operation is 
	 * missing.  The path of the structure is included as 
	 * part of the data field.  The data field will be of type
	 * {@link String} This event notification can be used 
	 * to display a user warning.
	 */
	public static final byte TYPE_MISSING_STRUCTURE = 0x01;
	
	/**
	 * A static instance of this class that is available for 
	 * clients to use.
	 */
	public static OperationEvent opeartionEvent = new OperationEvent();
	
	/**
	 * Indicates the event type
	 */
	public byte type;
	
	/**
	 * Used to interrupt the import operation
	 */
	public boolean doit;  
	
	/**
	 * The data field may/may not be set based on the specific 
	 * event type
	 */
	public Object data;
}
