/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.CompletionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.InstallUnitImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.LanguageImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.ResultingChangeImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Completion;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.InstallableUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Language;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ResultingChange;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallableUnitImpl
extends InstallUnitImpl
implements InstallableUnit {
    private static final String INSTALLABLE_UNIT_TYPE = "sdd-dd:InstallableUnitType";
    private static final String LANGUAGES_TYPE = "sdd-dd:LanguagesType";

    public InstallableUnitImpl(Element data, SPISessionImpl session) {
        super(data, session, INSTALLABLE_UNIT_TYPE);
    }

    @Override
    public String toString() {
        return "IU...\n" + super.toString();
    }

    @Override
    public Collection<Completion> getInstallableUnitCompletion() {
        Collection<Element> completionElements = this.getChildren("Completion");
        ArrayList<Completion> completions = new ArrayList<Completion>();
        for (Element element : completionElements) {
            completions.add(new CompletionImpl(element, this.session));
        }
        return completions;
    }

    @Override
    public Collection<ResultingChange> getResultingChanges() {
        Collection<Element> resultingChangeElements = this.getChildren("ResultingChange");
        ArrayList<ResultingChange> resultingChanges = new ArrayList<ResultingChange>();
        for (Element element : resultingChangeElements) {
            resultingChanges.add(new ResultingChangeImpl(element, this.session));
        }
        return resultingChanges;
    }

    @Override
    public Collection<Language> getLanguages() {
        ArrayList<Language> languages = new ArrayList<Language>();
        if (this.isSetElement("Languages")) {
            Collection<Element> languageElementList = this.session.getChildren(this.getChild("Languages"), "Language");
            for (Element element : languageElementList) {
                languages.add(new LanguageImpl(element, this.session));
            }
        }
        return languages;
    }

    @Override
    public void setCompletion(Collection<Completion> installableUnitCompletion) {
        if (installableUnitCompletion != null && !installableUnitCompletion.isEmpty()) {
            this.removeContent(this.getChildren("Completion", false));
            this.addContent(installableUnitCompletion);
        } else {
            this.removeContent(this.getChildren("Completion", false));
        }
    }

    @Override
    public void setResultingChanges(Collection<ResultingChange> newResultingChanges) {
        if (newResultingChanges != null && !newResultingChanges.isEmpty()) {
            this.removeContent(this.getChildren("ResultingChange", false));
            this.addContent(newResultingChanges);
        } else {
            this.removeContent(this.getChildren("ResultingChange", false));
        }
    }

    @Override
    public void setLanguages(Collection<Language> languages) {
        if (languages != null && !languages.isEmpty()) {
            Element languagesElement = this.isSetElement("Languages") ? this.getChild("Languages") : this.session.createDeploymentElement("Languages");
            Collection<Element> languageNodeList = this.session.getChildren(languagesElement, "Language");
            for (Element element : languageNodeList) {
                languagesElement.removeChild(element);
            }
            for (Language language : languages) {
                this.session.insertNode((Node)languagesElement, (SPIDataObject)((Object)language), LANGUAGES_TYPE);
            }
            this.setContent(languagesElement);
        } else {
            this.unSetElement("Languages");
        }
    }
}

