/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.xmldsig;

/**
 * 
 * DSA keys and the DSA signature algorithm are specified in [DSS]. DSA public key values 
 * can have the following fields:
 * P
 *  a prime modulus meeting the [DSS] requirements
 * Q
 *  an integer in the range 2**159 < Q < 2**160 which is a prime divisor of P-1
 * G
 *  an integer with certain properties with respect to P and Q
 * Y
 *  G**X mod P (where X is part of the private key and not made public)
 * J
 *  (P - 1) / Q
 * seed
 *  a DSA prime generation seed
 * pgenCounter
 *  a DSA prime generation counter 
 *
 * Parameter J is available for inclusion solely for efficiency as it is calculatable 
 * from P and Q. Parameters seed and pgenCounter are used in the DSA prime number generation 
 * algorithm specified in [DSS]. As such, they are optional but must either both be present 
 * or both be absent. This prime generation algorithm is designed to provide assurance that 
 * a weak prime is not being used and it yields a P and Q value. Parameters P, Q, and G can 
 * be public and common to a group of users. They might be known from application context. 
 * As such, they are optional but P and Q must either both appear or both be absent. 
 * If all of P, Q, seed, and pgenCounter are present, implementations are not required to 
 * check if they are consistent and are free to use either P and Q or seed and pgenCounter. 
 * All parameters are encoded as base64 [MIME] values.
 * 
 * Arbitrary-length integers (e.g. "bignums" such as RSA moduli) are represented in XML as 
 * octet strings as defined by the ds:CryptoBinary type.
 */
public interface DSAKeyValue {
	/**
	 * Gets P.
	 * 
	 * @return Value of P.
	 */
	byte[] getP();
	
	/**
	 * Sets P.
	 * 
	 * @param p Value of P.
	 */
	void setP(byte[] p);
	
	/**
	 * Gets Q.
	 * 
	 * @return Value of Q.
	 */
	byte[] getQ();
	
	/**
	 * Sets Q.
	 * 
	 * @param q Value of Q.
	 */
	void setQ(byte[] q);
	
	/**
	 * Gets G.
	 * 
	 * @return Value of G.
	 */
	byte[] getG();
	
	/**
	 * Sets G.
	 * 
	 * @param g Value of G.
	 */
	void setG(byte[] g);
	
	/**
	 * Gets Y.
	 * 
	 * @return Value of Y.
	 */
	byte[] getY();
	
	/**
	 * Sets Y.
	 * 
	 * @param y Value of Y.
	 */
	void setY(byte[] y);
	
	/**
	 * Gets J.
	 * 
	 * @return Value of J.
	 */
	byte[] getJ();
	
	/**
	 * Sets J.
	 * 
	 * @param j Value of J.
	 */
	void setJ(byte[] j);
	
	/**
	 * Gets Seed.
	 * 
	 * @return Value of Seed.
	 */
	byte[] getSeed();
	
	/**
	 * Sets Seed.
	 * 
	 * @param seed Value of Seed.
	 */
	void setSeed(byte[] seed);
	
	/**
	 * Gets pgenCounter.
	 * 
	 * @return Value of pgenCounter.
	 */
	byte[] getPgenCounter();
	
	/**
	 * Sets pgenCounter.
	 * 
	 * @param pgenCounter Value of pgenCounter.
	 */
	void setPgenCounter(byte[] pgenCounter);
}
