/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.DeploymentDescriptor;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.CompositeInstallable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.InstallableUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Language;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.LocalizationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ConfigurationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ResultingResource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.DerivedVariable;



public class LanguageType {

	public static Collection <Language> merge(Collection <Language> languages1, Collection <Language> languages2)
	{
		// set to hold all the merged variables
		Collection <Language> languagesToRemove = new ArrayList <Language> ();
		Iterator <Language> languageIter1 = languages1.iterator();		
		//iterate through the languages
		while (languageIter1.hasNext())
		{
			Language language1 = (Language) languageIter1.next();
			Iterator <Language> languageIter2 = languages2.iterator();
			while (languageIter2.hasNext())
			{
				Language language2 = (Language) languageIter2.next();
				//if you find a match that hasn't been found, note it
				//one of the equals needs to be deleted with its children merged over
				if (languagesToRemove.contains(language2)==false)
				{
					if (equals(language1, language2))
					{  //merge hosted languages, types and description languages
						languagesToRemove.add(language2);						
						language1 = merge(language1,language2);						
					}
				}
					
			}
		}
		
		languages2.removeAll(languagesToRemove);
		//remove all of the matches that were found
		
		Collection <Language> finalLanguages = new ArrayList <Language> ();
		//create and return a new collection with all of the remaining items
		finalLanguages.addAll(languages1);
		finalLanguages.addAll(languages2);		
		
		return finalLanguages;
		
	}
	
	private static Language merge(Language language1, Language language2)
	{
		language1.setDescription(TranslatableStringType.merge(language1.getDescription(),language2.getDescription()));
		language1.setDisplayName(TranslatableStringType.merge(language1.getDisplayName(),language2.getDisplayName()));
		language1.setShortDescription(TranslatableStringType.merge(language1.getShortDescription(),language2.getShortDescription()));
		
		return language1;
	}

	public static boolean equals(Language language1, Language language2)
	{
		if (StringType.equals(language1.getType(),language2.getType()))
			return true;
		
		return false;
		
	}
	
}
