/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.internal.dr.drs.service.outputter;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.AbstractOutputter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IOutputterContext;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IParameters;
import org.eclipse.cosmos.provisional.dr.ps.common.IConstants;

public abstract class AbstractGraphResponse extends AbstractOutputter 
{
	protected String rootDir;
	
	public void initalize(IOutputterContext context, IParameters parameters) throws Exception 
	{
		this.rootDir = context.getRealPath(IConstants.QUERYREPO+File.separator + IConstants.RESPONSEDIR);		
		super.initalize(context, parameters);
	}

	public String loadFromHistory(String uuid, String historyId) throws IOException
	{
		// Grab the content of the query response from the cached file
		// if there is a history id
		String queryResponse = null; 
		String historyFilename = rootDir+File.separator + uuid+File.separator+historyId+"."+IConstants.RESPONSEEXT;
		File file = new File(historyFilename);
	
		if (file.exists())
		{
			StringBuffer buffer = new StringBuffer();
			FileInputStream fis = null;

			try 
			{
				fis = new FileInputStream(file);	
				int i;					 
				while ((i = fis.read()) != -1)
				   buffer.append((char)i);
				 
				fis.close();					 
			} 
			finally 
			{	
				if (fis != null)
					fis.close();			
			}
			
			queryResponse = buffer.toString();				
		}
		
		return queryResponse;
	}
}
