/*******************************************************************************
 * Copyright (c) 2008 CA Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CA - initial implementation
 *******************************************************************************/
package org.eclipse.cosmos.examples.e2e.dr.template;

import java.net.URI;
import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.cosmos.common.provisional.exceptions.CosmosException;

import org.eclipse.cosmos.dc.internal.logging.datamgr.client.CBEClient;
import org.eclipse.cosmos.dc.internal.logging.datamgr.client.CBESeverityCount;
import org.eclipse.tptp.logging.events.cbe.CommonBaseEvent;
import org.apache.log4j.Logger;

public class NewHelper {
	private Logger logger = Logger.getLogger(getClass());
	private static NewHelper instance = new NewHelper();
			
	public static NewHelper getNewHelperInstance(){
		return instance;
	}
		
		
	public Collection<CommonBaseEvent> getAllCBE(String address,String logfile) throws Exception {
		Collection<CommonBaseEvent> e = null;
		CBEClient dmc = null;
				
		P(Messages.getString("GETALLCBE_INFO"),address,logfile); //$NON-NLS-1$
		
		try {
			dmc = new CBEClient(address);
			e = dmc.getAllCBE(logfile);
		} catch (CosmosException ae) {
			ae.printStackTrace();
			return null;
		}
		return e;
	}
		
	public Collection<CBESeverityCount> getCBECountBySeverity(String address,String logfile) throws Exception {
		Collection<CBESeverityCount> sev = null;
		CBEClient dmc = null;
		URI addr = null;
		
		P(Messages.getString("CBECOUNT_INFO"),address,logfile); //$NON-NLS-1$
		
		try { 
			dmc = new CBEClient(address);	
			sev = dmc.getCBECountBySeverity(logfile);
		} catch (CosmosException ae) {
			ae.printStackTrace();
			return null;
		}
		return sev;
	}
	private void P(String mesg,String str1,String str2) {
		logger.debug(MessageFormat.format(Messages.getString(mesg), new Object[] { str1,str2}));
	}
}

