/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts;

import java.net.URI;

import org.eclipse.cosmos.dc.internal.cmdbf.services.query.transform.input.artifacts.ContentSelector;
import org.eclipse.cosmos.dc.internal.cmdbf.services.query.transform.input.artifacts.DepthLimit;
import org.eclipse.cosmos.dc.internal.cmdbf.services.query.transform.input.artifacts.InstanceIdConstraint;
import org.eclipse.cosmos.dc.internal.cmdbf.services.query.transform.input.artifacts.ItemReference;
import org.eclipse.cosmos.dc.internal.cmdbf.services.query.transform.input.artifacts.ItemTemplate;
import org.eclipse.cosmos.dc.internal.cmdbf.services.query.transform.input.artifacts.Operator;
import org.eclipse.cosmos.dc.internal.cmdbf.services.query.transform.input.artifacts.PrefixMapping;
import org.eclipse.cosmos.dc.internal.cmdbf.services.query.transform.input.artifacts.PropertyId;
import org.eclipse.cosmos.dc.internal.cmdbf.services.query.transform.input.artifacts.PropertyValue;
import org.eclipse.cosmos.dc.internal.cmdbf.services.query.transform.input.artifacts.Query;
import org.eclipse.cosmos.dc.internal.cmdbf.services.query.transform.input.artifacts.RecordConstraint;
import org.eclipse.cosmos.dc.internal.cmdbf.services.query.transform.input.artifacts.RecordType;
import org.eclipse.cosmos.dc.internal.cmdbf.services.query.transform.input.artifacts.RelationshipEndpoint;
import org.eclipse.cosmos.dc.internal.cmdbf.services.query.transform.input.artifacts.RelationshipTemplate;
import org.eclipse.cosmos.dc.internal.cmdbf.services.query.transform.input.artifacts.SelectedRecordType;
import org.eclipse.cosmos.dc.internal.cmdbf.services.query.transform.input.artifacts.XPathExpression;
import org.eclipse.cosmos.dc.internal.cmdbf.services.transform.artifacts.CommonArtifactFactory;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.artifacts.IContentSelector;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IInstanceId;

/**
 * Factory for creating artifacts needed for submitting a query to an MDR
 * 
 * 
 * @author Ali Mehregani
 */
public class QueryInputArtifactFactory implements IQueryInputArtifactFactory
{
	private static IQueryInputArtifactFactory instance;

	public static IQueryInputArtifactFactory getInstance() {
		if (instance == null) {
			instance = new QueryInputArtifactFactory();
		}

		return instance;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IQueryInputArtifactFactory#createInstanceIdConstraint()
	 */
	public IInstanceIdConstraint createInstanceIdConstraint()
	{
		return new InstanceIdConstraint();
	}
		
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IQueryInputArtifactFactory#createInstanceId()
	 */
	public IInstanceId createInstanceId()
	{
		return CommonArtifactFactory.getInstance().createInstanceId();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IQueryInputArtifactFactory#createRelationshipEndpoint(int)
	 */
	public IRelationshipEndpoint createRelationshipEndpoint(int type)
	{
		return new RelationshipEndpoint(type);
	}
	
	
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IQueryInputArtifactFactory#createItemReference()
	 */
	public IItemReference createItemReference()
	{
		return new ItemReference();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IQueryInputArtifactFactory#createItemTemplate(java.lang.String)
	 */
	public IItemTemplate createItemTemplate(String id)
	{
		return new ItemTemplate(id);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IQueryInputArtifactFactory#createOperator(int)
	 */
	public IOperator createOperator(int type)
	{
		return new Operator(type);
	}	
	
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IQueryInputArtifactFactory#createPrefixMapping()
	 */
	public IPrefixMapping createPrefixMapping()
	{
		return new PrefixMapping();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IQueryInputArtifactFactory#createProperty()
	 */
	public IProperty createProperty()
	{
		return new BaseProperty();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IQueryInputArtifactFactory#createPropertyId()
	 */
	public IPropertyId createPropertyId()
	{
		return new PropertyId();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IQueryInputArtifactFactory#createContentSelector()
	 */
	public IContentSelector createContentSelector()
	{
		return new ContentSelector();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IQueryInputArtifactFactory#createPropertyValue()
	 */
	public IPropertyValue createPropertyValue()
	{
		return new PropertyValue();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IQueryInputArtifactFactory#createQuery()
	 */
	public IQuery createQuery()
	{
		return new Query();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IQueryInputArtifactFactory#createRecordType()
	 */
	public IRecordType createRecordType()
	{
		return new RecordType();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IQueryInputArtifactFactory#createRelationshipTemplate(java.lang.String)
	 */
	public IRelationshipTemplate createRelationshipTemplate(String id)
	{
		return new RelationshipTemplate(id);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IQueryInputArtifactFactory#createXPathExpression(java.net.URI)
	 */
	public IXPathExpression createXPathExpression(URI dialectURI)
	{
		return new XPathExpression(dialectURI);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IQueryInputArtifactFactory#createDepthLimit()
	 */
	public IDepthLimit createDepthLimit ()
	{
		return new DepthLimit();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IQueryInputArtifactFactory#createSelectedRecordType()
	 */
	public ISelectedRecordType createSelectedRecordType() {
		return new SelectedRecordType();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IQueryInputArtifactFactory#createRecordConstraint()
	 */
	public IRecordConstraint createRecordConstraint() {
		return new RecordConstraint();
	}
}
