/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.me.internal.dmtoolkit.j2ee.ui;

import org.eclipse.cosmos.me.internal.dmtoolkit.common.ui.DataManagerConfigPage;
import org.eclipse.cosmos.me.internal.dmtoolkit.j2ee.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.ui.IFacetWizardPage;
import org.eclipse.wst.common.project.facet.ui.IWizardContext;

/**
 * Specialized class that provides the IFacetWizardPage interface required by
 * the facet UI framework.
 * 
 * @author David Whiteman
 */
public class DataManagerConfigFacetInstallPage extends DataManagerConfigPage implements IFacetWizardPage {

	//private IWizardContext context;

	private static final String PAGE_NAME = "org.eclipse.cosmos.me.dmtoolkit.j2ee.config"; //$NON-NLS-1$

	public DataManagerConfigFacetInstallPage() {
		super(PAGE_NAME);
	}

	public void setConfig(Object config) {
		setModel(config);
    	initBanner();
	}

    public final void setWizardContext( final IWizardContext context )
    {
        //this.context = context;
    }

	protected void initBanner() {
		String projectTypeName = getModel().getProjectTypeName();
		String nameForTitle = Character.toUpperCase(projectTypeName.charAt(0))+ projectTypeName.substring(1);
		setTitle(NLS.bind(Messages.dataManagerConfigPageTitle, nameForTitle));
    	setDescription(NLS.bind(Messages.dataManagerConfigPageDescription, projectTypeName));
    	setNameTextLabel(NLS.bind("{0} name:", nameForTitle));
	}

	public void transferStateToConfig() {
		transferStateToModel();
	}


}
