/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.query.service;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.cmdbfservice.IQueryHandler;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IConstraint;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.IEdges;

/**
 * A relationship constraint handler is used to make requests of the
 * form: "Return me all relationships that satisfy a constraint"
 * 
 * 
 * @author Ali Mehregani
 */
public interface IRelationshipConstraintHandler extends IQueryHandler
{
	/**
	 * Execute this relationship constraint handler.  The returned collection 
	 * is expected to be a subset of the context argument.  That is, the 
	 * returned collection must be constructed by adding all or a subset of 
	 * the edges in context.
	 * 
	 * @param context The context to work with 
	 * @param constraint The constraint
	 * @return The output for executing this relationship constraint handler
	 * @throws CMDBfServiceException In case of an error
	 */
	public IEdges execute(IEdges context, IConstraint constraint) throws CMDBfServiceException;

}
