/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.internal.cmdbf.services.query.transform.input.artifacts;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.IXMLWritable;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.artifacts.IContentSelector;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.artifacts.ITemplate;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IInstanceIdConstraint;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IRecordConstraint;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IXPathExpression;

public abstract class Template
implements ITemplate,
IXMLWritable {
    private String id;
    private Boolean suppressFromResult = null;
    private IInstanceIdConstraint instanceIdConstraint;
    private List<IXPathExpression> xpathExpressions = new ArrayList<IXPathExpression>();
    private List<IRecordConstraint> recordConstraints = new ArrayList<IRecordConstraint>();
    private IContentSelector contentSelector;

    public Template(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isSuppressFromResult() {
        if (this.primIsSuppressFromResult() == null) {
            return false;
        }
        return this.primIsSuppressFromResult();
    }

    private Boolean primIsSuppressFromResult() {
        return this.suppressFromResult;
    }

    public void setSuppressFromResult(boolean dropDirective) {
        this.suppressFromResult = dropDirective;
    }

    public IInstanceIdConstraint getInstanceIdConstraint() {
        return this.instanceIdConstraint;
    }

    public void setInstanceIdConstraint(IInstanceIdConstraint instanceIdConstraint) {
        this.instanceIdConstraint = instanceIdConstraint;
    }

    public IContentSelector getContentSelector() {
        return this.contentSelector;
    }

    public void setContentSelector(IContentSelector contentSelector) {
        this.contentSelector = contentSelector;
    }

    public IRecordConstraint[] getRecordConstraints() {
        return this.recordConstraints.toArray(new IRecordConstraint[this.recordConstraints.size()]);
    }

    public IXPathExpression[] getXpathExpressions() {
        return this.xpathExpressions.toArray(new IXPathExpression[this.xpathExpressions.size()]);
    }

    public void addXpathExpression(IXPathExpression expression) {
        this.xpathExpressions.add(expression);
    }

    public void addRecordConstraint(IRecordConstraint recordConstraint) {
        this.recordConstraints.add(recordConstraint);
    }

    public void toXML(StringWriter writer, int indent) {
        CMDBfServicesUtil.addIndent((StringWriter)writer, (int)indent);
        writer.write("<cmdbf:" + this.getElementName() + " ");
        CMDBfServicesUtil.writeAttribute((StringWriter)writer, (String)"id", (String)this.getId());
        if (this.primIsSuppressFromResult() != null) {
            writer.write(" ");
            CMDBfServicesUtil.writeAttribute((StringWriter)writer, (String)"suppressFromResult", (String)this.primIsSuppressFromResult().toString());
        }
        writer.write(">" + ICMDBfServicesConstants.nl);
        if (this.xpathExpressions.size() > 0) {
            CMDBfServicesUtil.outputListToXML((StringWriter)writer, (int)(indent + 1), this.xpathExpressions);
        } else {
            if (this.getContentSelector() != null) {
                this.getContentSelector().toXML(writer, indent + 1);
            }
            if (this.getInstanceIdConstraint() != null) {
                this.getInstanceIdConstraint().toXML(writer, indent + 1);
            }
            CMDBfServicesUtil.outputListToXML((StringWriter)writer, (int)(indent + 1), this.recordConstraints);
        }
        this.outputAdditionalSubelements(writer, indent + 1);
        CMDBfServicesUtil.addIndent((StringWriter)writer, (int)indent);
        writer.write(String.valueOf(CMDBfServicesUtil.endTagFor((String)("cmdbf:" + this.getElementName()))) + ICMDBfServicesConstants.nl);
    }

    protected void outputAdditionalSubelements(StringWriter writer, int indent) {
    }

    protected abstract String getElementName();

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.contentSelector == null ? 0 : this.contentSelector.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.instanceIdConstraint == null ? 0 : this.instanceIdConstraint.hashCode());
        result = 31 * result + (this.recordConstraints == null ? 0 : this.recordConstraints.hashCode());
        result = 31 * result + (this.suppressFromResult == null ? 0 : this.suppressFromResult.hashCode());
        result = 31 * result + (this.xpathExpressions == null ? 0 : this.xpathExpressions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Template other = (Template)obj;
        if (this.contentSelector == null ? other.contentSelector != null : !this.contentSelector.equals(other.contentSelector)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.instanceIdConstraint == null ? other.instanceIdConstraint != null : !this.instanceIdConstraint.equals(other.instanceIdConstraint)) {
            return false;
        }
        if (this.recordConstraints == null ? other.recordConstraints != null : !this.recordConstraints.equals(other.recordConstraints)) {
            return false;
        }
        if (this.suppressFromResult == null ? other.suppressFromResult != null : !this.suppressFromResult.equals(other.suppressFromResult)) {
            return false;
        }
        return !(this.xpathExpressions == null ? other.xpathExpressions != null : !this.xpathExpressions.equals(other.xpathExpressions));
    }
}

