/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.tooling.btg.rpm;

import java.util.Collection;
import java.util.Properties;
import junit.framework.TestCase;
import org.eclipse.cosmos.me.internal.deployment.sdd.tests.tooling.btg.rpm.AllTests;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.DeploymentDescriptor;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.PackageDescriptor;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.BTGProperty;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.SDDFragment;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.rpm.RPMDataCollector;

public class RPMDataCollector_Test
extends TestCase {
    private RPMDataCollector rpmDC = new RPMDataCollector();

    public RPMDataCollector_Test(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetSupportedProperties() throws Exception {
        Collection<BTGProperty> btgp = this.rpmDC.getSupportedProperties();
        RPMDataCollector_Test.assertTrue((btgp != null ? 1 : 0) != 0);
        RPMDataCollector_Test.assertEquals((int)btgp.size(), (int)1);
        RPMDataCollector_Test.assertEquals((String)"FileName", (String)btgp.toArray(new BTGProperty[0])[0].getName());
        RPMDataCollector_Test.assertTrue((boolean)btgp.toArray(new BTGProperty[0])[0].isRequired());
    }

    public void testValidFileName() {
        Properties props = new Properties();
        props.put("FileName", AllTests.VALID_RPM);
        Collection<SDDFragment> sdds = this.rpmDC.collectSDDData(props);
        RPMDataCollector_Test.assertNotNull(sdds);
        RPMDataCollector_Test.assertEquals((int)sdds.size(), (int)2);
        RPMDataCollector_Test.assertTrue((boolean)(sdds.toArray(new SDDFragment[0])[0].getFragment() instanceof PackageDescriptor));
        RPMDataCollector_Test.assertTrue((boolean)(sdds.toArray(new SDDFragment[0])[1].getFragment() instanceof DeploymentDescriptor));
    }

    public void testInvalidFileName() {
        Properties props = new Properties();
        props.put("FileName", String.valueOf(AllTests.ARTIFACTSFILE_LOCATION) + "FileNotHere.rpm");
        Collection<SDDFragment> sdds = this.rpmDC.collectSDDData(props);
        RPMDataCollector_Test.assertNull(sdds);
    }
}

