/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.common.spi;

import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import junit.framework.TestCase;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.SPISession;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.Condition;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Feature;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Language;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.LanguageSet;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Multiplicity;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.NestedFeature;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.PackageFeatureReference;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.DerivedVariable;
import org.w3c.dom.Element;

public class Feature_Test
extends TestCase {
    Feature feature;
    Feature clonedFeature;
    Element element;
    SPISessionImpl session;

    public Feature_Test(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        DerivedVariable var1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createVariable("var1ID", "var1Expression");
        DerivedVariable var2 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createVariable("var2ID", "var2Expression");
        this.feature = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createFeatureWithDerivedVariables("featureID", (Collection<DerivedVariable>)Arrays.asList(var1, var2));
        this.feature.setAddOn(Boolean.TRUE);
        this.feature.setDisplayName(new TranslatableString("displayName", "displayNameKey"));
        Condition condition = SPISession.DEFAULT_INSTANCE.createConditionFactory().createCondition();
        condition.setDescription(new TranslatableString("conditionDesc", "conditionDescKey"));
        this.feature.setCondition(condition);
        this.feature.setContentElements((Collection<String>)Arrays.asList("content1", "content2"));
        this.feature.setDescription(new TranslatableString("desc", "descKey"));
        this.feature.setShortDescription(new TranslatableString("shortDesc", "shortDescKey"));
        Language lang1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("lang1Type");
        Language lang2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("lang2Type");
        this.feature.setMandatoryLanguages((Collection<Language>)Arrays.asList(lang1, lang2));
        Multiplicity multi = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createMultiplicity(Boolean.TRUE);
        this.feature.setMultiplicity(multi);
        NestedFeature feature1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createNestedFeatureWithDerivedVariables("nestedFeature1ID", (Collection<DerivedVariable>)Arrays.asList(var1, var2));
        NestedFeature feature2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createNestedFeatureWithDerivedVariables("nestedFeature2ID", (Collection<DerivedVariable>)Arrays.asList(var1, var2));
        this.feature.setNestedFeatures((Collection<NestedFeature>)Arrays.asList(feature1, feature2));
        Language optLang1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("optLang1Type");
        Language optLang2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("optLang2Type");
        this.feature.setOptionalLanguages((Collection<Language>)Arrays.asList(optLang1, optLang2));
        Language langSetLang1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("langSetLang1");
        Language langSetLang2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("langSetLang2");
        Language langSetLang3 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("langSetLang3");
        Language langSetLang4 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("langSetLang4");
        LanguageSet langSet1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguageSet((Collection<Language>)Arrays.asList(langSetLang1, langSetLang2));
        LanguageSet langSet2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguageSet((Collection<Language>)Arrays.asList(langSetLang3, langSetLang4));
        this.feature.setOptionalLanguageSets((Collection<LanguageSet>)Arrays.asList(langSet1, langSet2));
        PackageFeatureReference featureRef1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createPackageFeatureReference("contentRef1", "featureRef1");
        PackageFeatureReference featureRef2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createPackageFeatureReference("contentRef2", "featureRef2");
        this.feature.setPackageFeatureReferences((Collection<PackageFeatureReference>)Arrays.asList(featureRef1, featureRef2));
        this.feature.setRequiredFeature((Collection<String>)Arrays.asList("feature1", "feature2"));
        this.feature.setRequired(Boolean.TRUE);
        this.clonedFeature = (Feature)this.feature.clone();
        this.element = ((SPIDataObject)((Object)this.feature)).getElement();
        this.session = (SPISessionImpl)SPISession.DEFAULT_INSTANCE;
    }

    public void testGetRequired() {
        Feature_Test.assertTrue((boolean)this.feature.getRequired());
        Feature_Test.assertTrue((boolean)this.clonedFeature.getRequired());
        Feature_Test.assertTrue((boolean)Boolean.parseBoolean(this.element.getAttribute("required")));
    }

    public void testSetRequired() {
        this.feature.setRequired(Boolean.FALSE);
        Feature_Test.assertFalse((boolean)this.feature.getRequired());
        Feature_Test.assertFalse((boolean)Boolean.parseBoolean(this.element.getAttribute("required")));
    }

    public void testGetTranslatableStrings() {
        Properties props = ((SPIDataObject)((Object)this.feature)).getTranslatableStrings();
        Properties clonedProps = ((SPIDataObject)((Object)this.clonedFeature)).getTranslatableStrings();
        Feature_Test.assertEquals((int)4, (int)props.keySet().size());
        Feature_Test.assertEquals((int)4, (int)clonedProps.keySet().size());
        Feature_Test.assertEquals((Object)"desc", (Object)props.get("descKey"));
        Feature_Test.assertEquals((Object)"shortDesc", (Object)props.get("shortDescKey"));
        Feature_Test.assertEquals((Object)"shortDesc", (Object)props.get("shortDescKey"));
        Feature_Test.assertEquals((Object)"displayName", (Object)props.get("displayNameKey"));
        Feature_Test.assertEquals((Object)"desc", (Object)clonedProps.get("descKey"));
        Feature_Test.assertEquals((Object)"shortDesc", (Object)clonedProps.get("shortDescKey"));
        Feature_Test.assertEquals((Object)"conditionDesc", (Object)clonedProps.get("conditionDescKey"));
        Feature_Test.assertEquals((Object)"displayName", (Object)clonedProps.get("displayNameKey"));
    }

    public void testGetMandatoryLanguages() {
        Collection<Language> langs = this.feature.getMandatoryLanguages();
        Collection<Language> clonedLangs = this.feature.getMandatoryLanguages();
        Collection<Element> dataObjectLangs = this.session.getChildren(this.session.getChild(this.session.getChild(this.element, "Languages"), "Mandatory"), "Language");
        Feature_Test.assertEquals((int)2, (int)langs.size());
        Feature_Test.assertEquals((int)2, (int)clonedLangs.size());
        Feature_Test.assertEquals((int)2, (int)dataObjectLangs.size());
        Feature_Test.assertEquals((String)"lang1Type", (String)langs.toArray(new Language[0])[0].getType());
        Feature_Test.assertEquals((String)"lang2Type", (String)langs.toArray(new Language[0])[1].getType());
        Feature_Test.assertEquals((String)"lang1Type", (String)clonedLangs.toArray(new Language[0])[0].getType());
        Feature_Test.assertEquals((String)"lang2Type", (String)clonedLangs.toArray(new Language[0])[1].getType());
        Feature_Test.assertEquals((String)"lang1Type", (String)dataObjectLangs.toArray(new Element[0])[0].getAttribute("type"));
        Feature_Test.assertEquals((String)"lang2Type", (String)dataObjectLangs.toArray(new Element[0])[1].getAttribute("type"));
    }

    public void testGetOptionalLanguages() {
        Collection<Language> langs = this.feature.getOptionalLanguages();
        Collection<Language> clonedLangs = this.feature.getOptionalLanguages();
        Collection<Element> dataObjectLangs = this.session.getChildren(this.session.getChild(this.session.getChild(this.element, "Languages"), "Optional"), "Language");
        Feature_Test.assertEquals((int)2, (int)langs.size());
        Feature_Test.assertEquals((int)2, (int)clonedLangs.size());
        Feature_Test.assertEquals((int)2, (int)dataObjectLangs.size());
        Feature_Test.assertEquals((String)"optLang1Type", (String)langs.toArray(new Language[0])[0].getType());
        Feature_Test.assertEquals((String)"optLang2Type", (String)langs.toArray(new Language[0])[1].getType());
        Feature_Test.assertEquals((String)"optLang1Type", (String)clonedLangs.toArray(new Language[0])[0].getType());
        Feature_Test.assertEquals((String)"optLang2Type", (String)clonedLangs.toArray(new Language[0])[1].getType());
        Feature_Test.assertEquals((String)"optLang1Type", (String)dataObjectLangs.toArray(new Element[0])[0].getAttribute("type"));
        Feature_Test.assertEquals((String)"optLang2Type", (String)dataObjectLangs.toArray(new Element[0])[1].getAttribute("type"));
    }

    public void testGetOptionalLanguageSets() {
        Collection<LanguageSet> langSets = this.feature.getOptionalLanguageSets();
        Collection<LanguageSet> clonedLangSets = this.feature.getOptionalLanguageSets();
        Collection<Element> dataObjectLangSets = this.session.getChildren(this.session.getChild(this.session.getChild(this.element, "Languages"), "Optional"), "LanguageSet");
        Feature_Test.assertEquals((int)2, (int)langSets.size());
        Feature_Test.assertEquals((int)2, (int)clonedLangSets.size());
        Feature_Test.assertEquals((int)2, (int)dataObjectLangSets.size());
        Feature_Test.assertEquals((String)"langSetLang1", (String)langSets.toArray(new LanguageSet[0])[0].getLanguages().toArray(new Language[0])[0].getType());
        Feature_Test.assertEquals((String)"langSetLang2", (String)langSets.toArray(new LanguageSet[0])[0].getLanguages().toArray(new Language[0])[1].getType());
        Feature_Test.assertEquals((String)"langSetLang3", (String)langSets.toArray(new LanguageSet[0])[1].getLanguages().toArray(new Language[0])[0].getType());
        Feature_Test.assertEquals((String)"langSetLang4", (String)langSets.toArray(new LanguageSet[0])[1].getLanguages().toArray(new Language[0])[1].getType());
        Feature_Test.assertEquals((String)"langSetLang1", (String)clonedLangSets.toArray(new LanguageSet[0])[0].getLanguages().toArray(new Language[0])[0].getType());
        Feature_Test.assertEquals((String)"langSetLang2", (String)clonedLangSets.toArray(new LanguageSet[0])[0].getLanguages().toArray(new Language[0])[1].getType());
        Feature_Test.assertEquals((String)"langSetLang3", (String)clonedLangSets.toArray(new LanguageSet[0])[1].getLanguages().toArray(new Language[0])[0].getType());
        Feature_Test.assertEquals((String)"langSetLang4", (String)clonedLangSets.toArray(new LanguageSet[0])[1].getLanguages().toArray(new Language[0])[1].getType());
        Feature_Test.assertEquals((String)"langSetLang1", (String)this.session.getChildren(dataObjectLangSets.toArray(new Element[0])[0], "Language").toArray(new Element[0])[0].getAttribute("type"));
        Feature_Test.assertEquals((String)"langSetLang2", (String)this.session.getChildren(dataObjectLangSets.toArray(new Element[0])[0], "Language").toArray(new Element[0])[1].getAttribute("type"));
        Feature_Test.assertEquals((String)"langSetLang3", (String)this.session.getChildren(dataObjectLangSets.toArray(new Element[0])[1], "Language").toArray(new Element[0])[0].getAttribute("type"));
        Feature_Test.assertEquals((String)"langSetLang4", (String)this.session.getChildren(dataObjectLangSets.toArray(new Element[0])[1], "Language").toArray(new Element[0])[1].getAttribute("type"));
    }

    public void testGetCondition() {
        Feature_Test.assertEquals((String)"conditionDesc", (String)this.feature.getCondition().getDescription().getValue());
        Feature_Test.assertEquals((String)"conditionDescKey", (String)this.feature.getCondition().getDescription().getTranslationKey());
        Feature_Test.assertEquals((String)"conditionDesc", (String)this.clonedFeature.getCondition().getDescription().getValue());
        Feature_Test.assertEquals((String)"conditionDescKey", (String)this.clonedFeature.getCondition().getDescription().getTranslationKey());
        Feature_Test.assertEquals((String)"conditionDesc", (String)this.session.getChild(this.session.getChild(this.element, "Condition"), "Description").getTextContent());
        Feature_Test.assertEquals((String)"conditionDescKey", (String)this.session.getChild(this.session.getChild(this.element, "Condition"), "Description").getAttribute("translationKey"));
    }

    public void testGetContentElements() {
        Feature_Test.assertEquals((int)2, (int)this.feature.getContentElements().size());
        Feature_Test.assertEquals((String)"content1", (String)this.feature.getContentElements().toArray(new String[0])[0]);
        Feature_Test.assertEquals((String)"content2", (String)this.feature.getContentElements().toArray(new String[0])[1]);
        Feature_Test.assertEquals((int)2, (int)this.clonedFeature.getContentElements().size());
        Feature_Test.assertEquals((String)"content1", (String)this.clonedFeature.getContentElements().toArray(new String[0])[0]);
        Feature_Test.assertEquals((String)"content2", (String)this.clonedFeature.getContentElements().toArray(new String[0])[1]);
        Feature_Test.assertEquals((int)2, (int)this.session.getChildren(this.element, "ContentElement").size());
        Feature_Test.assertEquals((String)"content1", (String)this.session.getChildren(this.element, "ContentElement").toArray(new Element[0])[0].getAttribute("contentElementRef"));
        Feature_Test.assertEquals((String)"content2", (String)this.session.getChildren(this.element, "ContentElement").toArray(new Element[0])[1].getAttribute("contentElementRef"));
    }

    public void testGetMultiplicity() {
        Feature_Test.assertTrue((boolean)this.feature.getMultiplicity().getMultiplesAllowed());
        Feature_Test.assertTrue((boolean)this.clonedFeature.getMultiplicity().getMultiplesAllowed());
        Feature_Test.assertTrue((boolean)Boolean.parseBoolean(this.session.getChildren(this.element, "Multiplicity").toArray(new Element[0])[0].getAttribute("multiplesAllowed")));
    }

    public void testGetFeatureID() {
        Feature_Test.assertEquals((String)"featureID", (String)this.feature.getFeatureID());
        Feature_Test.assertEquals((String)"featureID", (String)this.clonedFeature.getFeatureID());
        Feature_Test.assertEquals((String)"featureID", (String)this.element.getAttribute("id"));
    }

    public void testGetNestedFeatures() {
        Feature_Test.assertEquals((int)2, (int)this.feature.getNestedFeatures().size());
        Feature_Test.assertEquals((String)"nestedFeature1ID", (String)this.feature.getNestedFeatures().toArray(new NestedFeature[0])[0].getFeatureID());
        Feature_Test.assertEquals((String)"nestedFeature2ID", (String)this.feature.getNestedFeatures().toArray(new NestedFeature[0])[1].getFeatureID());
        Feature_Test.assertEquals((int)2, (int)this.clonedFeature.getNestedFeatures().size());
        Feature_Test.assertEquals((String)"nestedFeature1ID", (String)this.clonedFeature.getNestedFeatures().toArray(new NestedFeature[0])[0].getFeatureID());
        Feature_Test.assertEquals((String)"nestedFeature2ID", (String)this.clonedFeature.getNestedFeatures().toArray(new NestedFeature[0])[1].getFeatureID());
        Feature_Test.assertEquals((int)2, (int)this.session.getChildren(this.element, "NestedFeature").size());
        Feature_Test.assertEquals((String)"nestedFeature1ID", (String)this.session.getChildren(this.element, "NestedFeature").toArray(new Element[0])[0].getAttribute("id"));
        Feature_Test.assertEquals((String)"nestedFeature2ID", (String)this.session.getChildren(this.element, "NestedFeature").toArray(new Element[0])[1].getAttribute("id"));
    }

    public void testGetRequiredFeature() {
        Feature_Test.assertEquals((int)2, (int)this.feature.getRequiredFeature().size());
        Feature_Test.assertEquals((String)"feature1", (String)this.feature.getRequiredFeature().toArray(new String[0])[0]);
        Feature_Test.assertEquals((String)"feature2", (String)this.feature.getRequiredFeature().toArray(new String[0])[1]);
        Feature_Test.assertEquals((int)2, (int)this.clonedFeature.getRequiredFeature().size());
        Feature_Test.assertEquals((String)"feature1", (String)this.clonedFeature.getRequiredFeature().toArray(new String[0])[0]);
        Feature_Test.assertEquals((String)"feature2", (String)this.clonedFeature.getRequiredFeature().toArray(new String[0])[1]);
        Feature_Test.assertEquals((int)2, (int)this.session.getChildren(this.element, "RequiredFeature").size());
        Feature_Test.assertEquals((String)"feature1", (String)this.session.getChildren(this.element, "RequiredFeature").toArray(new Element[0])[0].getAttribute("featureRef"));
        Feature_Test.assertEquals((String)"feature2", (String)this.session.getChildren(this.element, "RequiredFeature").toArray(new Element[0])[1].getAttribute("featureRef"));
    }

    public void testGetVariables() {
        Feature_Test.assertEquals((int)2, (int)this.feature.getVariables().size());
        Feature_Test.assertEquals((String)"var1ID", (String)this.feature.getVariables().toArray(new DerivedVariable[0])[0].getVariableID());
        Feature_Test.assertEquals((String)"var1Expression", (String)this.feature.getVariables().toArray(new DerivedVariable[0])[0].getExpression());
        Feature_Test.assertEquals((String)"var2ID", (String)this.feature.getVariables().toArray(new DerivedVariable[0])[1].getVariableID());
        Feature_Test.assertEquals((String)"var2Expression", (String)this.feature.getVariables().toArray(new DerivedVariable[0])[1].getExpression());
        Feature_Test.assertEquals((int)2, (int)this.clonedFeature.getVariables().size());
        Feature_Test.assertEquals((String)"var1ID", (String)this.clonedFeature.getVariables().toArray(new DerivedVariable[0])[0].getVariableID());
        Feature_Test.assertEquals((String)"var1Expression", (String)this.clonedFeature.getVariables().toArray(new DerivedVariable[0])[0].getExpression());
        Feature_Test.assertEquals((String)"var2ID", (String)this.clonedFeature.getVariables().toArray(new DerivedVariable[0])[1].getVariableID());
        Feature_Test.assertEquals((String)"var2Expression", (String)this.clonedFeature.getVariables().toArray(new DerivedVariable[0])[1].getExpression());
        Feature_Test.assertEquals((int)2, (int)this.session.getChildren(this.element, "Variable").size());
        Feature_Test.assertEquals((String)"var1ID", (String)this.session.getChildren(this.element, "Variable").toArray(new Element[0])[0].getAttribute("id"));
        Feature_Test.assertEquals((String)"var1Expression", (String)this.session.getChildren(this.session.getChildren(this.element, "Variable").toArray(new Element[0])[0], "Expression").toArray(new Element[0])[0].getTextContent());
        Feature_Test.assertEquals((String)"var2ID", (String)this.session.getChildren(this.element, "Variable").toArray(new Element[0])[1].getAttribute("id"));
        Feature_Test.assertEquals((String)"var2Expression", (String)this.session.getChildren(this.session.getChildren(this.element, "Variable").toArray(new Element[0])[1], "Expression").toArray(new Element[0])[0].getTextContent());
    }

    public void testGetPackageFeatureReferences() {
        Feature_Test.assertEquals((int)2, (int)this.feature.getPackageFeatureReferences().size());
        Feature_Test.assertEquals((String)"contentRef1", (String)this.feature.getPackageFeatureReferences().toArray(new PackageFeatureReference[0])[0].getContentElementRef());
        Feature_Test.assertEquals((String)"featureRef1", (String)this.feature.getPackageFeatureReferences().toArray(new PackageFeatureReference[0])[0].getPackageFeatureRef());
        Feature_Test.assertEquals((String)"contentRef2", (String)this.feature.getPackageFeatureReferences().toArray(new PackageFeatureReference[0])[1].getContentElementRef());
        Feature_Test.assertEquals((String)"featureRef2", (String)this.feature.getPackageFeatureReferences().toArray(new PackageFeatureReference[0])[1].getPackageFeatureRef());
        Feature_Test.assertEquals((int)2, (int)this.clonedFeature.getPackageFeatureReferences().size());
        Feature_Test.assertEquals((String)"contentRef1", (String)this.clonedFeature.getPackageFeatureReferences().toArray(new PackageFeatureReference[0])[0].getContentElementRef());
        Feature_Test.assertEquals((String)"featureRef1", (String)this.clonedFeature.getPackageFeatureReferences().toArray(new PackageFeatureReference[0])[0].getPackageFeatureRef());
        Feature_Test.assertEquals((String)"contentRef2", (String)this.clonedFeature.getPackageFeatureReferences().toArray(new PackageFeatureReference[0])[1].getContentElementRef());
        Feature_Test.assertEquals((String)"featureRef2", (String)this.clonedFeature.getPackageFeatureReferences().toArray(new PackageFeatureReference[0])[1].getPackageFeatureRef());
        Feature_Test.assertEquals((int)2, (int)this.session.getChildren(this.element, "PackageFeatureReference").size());
        Feature_Test.assertEquals((String)"contentRef1", (String)this.session.getChildren(this.element, "PackageFeatureReference").toArray(new Element[0])[0].getAttribute("contentElementRef"));
        Feature_Test.assertEquals((String)"featureRef1", (String)this.session.getChildren(this.element, "PackageFeatureReference").toArray(new Element[0])[0].getAttribute("packageFeatureRef"));
        Feature_Test.assertEquals((String)"contentRef2", (String)this.session.getChildren(this.element, "PackageFeatureReference").toArray(new Element[0])[1].getAttribute("contentElementRef"));
        Feature_Test.assertEquals((String)"featureRef2", (String)this.session.getChildren(this.element, "PackageFeatureReference").toArray(new Element[0])[1].getAttribute("packageFeatureRef"));
    }

    public void testGetAddOn() {
        Feature_Test.assertTrue((boolean)this.feature.getAddOn());
        Feature_Test.assertTrue((boolean)this.clonedFeature.getAddOn());
        Feature_Test.assertTrue((boolean)Boolean.parseBoolean(this.element.getAttribute("addOn")));
    }

    public void testGetDisplayName() {
        Feature_Test.assertEquals((String)"displayName", (String)this.feature.getDisplayName().getValue());
        Feature_Test.assertEquals((String)"displayNameKey", (String)this.feature.getDisplayName().getTranslationKey());
        Feature_Test.assertEquals((String)"displayName", (String)this.clonedFeature.getDisplayName().getValue());
        Feature_Test.assertEquals((String)"displayNameKey", (String)this.clonedFeature.getDisplayName().getTranslationKey());
        Feature_Test.assertEquals((String)"displayName", (String)this.session.getChildren(this.element, "DisplayName").toArray(new Element[0])[0].getTextContent());
        Feature_Test.assertEquals((String)"displayNameKey", (String)this.session.getChildren(this.element, "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testGetDescription() {
        Feature_Test.assertEquals((String)"desc", (String)this.feature.getDescription().getValue());
        Feature_Test.assertEquals((String)"descKey", (String)this.feature.getDescription().getTranslationKey());
        Feature_Test.assertEquals((String)"desc", (String)this.clonedFeature.getDescription().getValue());
        Feature_Test.assertEquals((String)"descKey", (String)this.clonedFeature.getDescription().getTranslationKey());
        Feature_Test.assertEquals((String)"desc", (String)this.session.getChildren(this.element, "Description").toArray(new Element[0])[0].getTextContent());
        Feature_Test.assertEquals((String)"descKey", (String)this.session.getChildren(this.element, "Description").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testGetShortDescription() {
        Feature_Test.assertEquals((String)"shortDesc", (String)this.feature.getShortDescription().getValue());
        Feature_Test.assertEquals((String)"shortDescKey", (String)this.feature.getShortDescription().getTranslationKey());
        Feature_Test.assertEquals((String)"shortDesc", (String)this.clonedFeature.getShortDescription().getValue());
        Feature_Test.assertEquals((String)"shortDescKey", (String)this.clonedFeature.getShortDescription().getTranslationKey());
        Feature_Test.assertEquals((String)"shortDesc", (String)this.session.getChildren(this.element, "ShortDescription").toArray(new Element[0])[0].getTextContent());
        Feature_Test.assertEquals((String)"shortDescKey", (String)this.session.getChildren(this.element, "ShortDescription").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetMandatoryLanguages() {
        Language lang1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("lang3Type");
        this.feature.setMandatoryLanguages((Collection<Language>)Arrays.asList(lang1));
        Collection<Language> langs = this.feature.getMandatoryLanguages();
        Collection<Element> dataObjectLangs = this.session.getChildren(this.session.getChild(this.session.getChild(this.element, "Languages"), "Mandatory"), "Language");
        Feature_Test.assertEquals((int)1, (int)langs.size());
        Feature_Test.assertEquals((int)1, (int)dataObjectLangs.size());
        Feature_Test.assertEquals((String)"lang3Type", (String)langs.toArray(new Language[0])[0].getType());
        Feature_Test.assertEquals((String)"lang3Type", (String)dataObjectLangs.toArray(new Element[0])[0].getAttribute("type"));
    }

    public void testSetOptionalLanguages() {
        Language optLang1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("optLang3Type");
        this.feature.setOptionalLanguages((Collection<Language>)Arrays.asList(optLang1));
        Collection<Language> langs = this.feature.getOptionalLanguages();
        Collection<Element> dataObjectLangs = this.session.getChildren(this.session.getChild(this.session.getChild(this.element, "Languages"), "Optional"), "Language");
        Feature_Test.assertEquals((int)1, (int)langs.size());
        Feature_Test.assertEquals((int)1, (int)dataObjectLangs.size());
        Feature_Test.assertEquals((String)"optLang3Type", (String)langs.toArray(new Language[0])[0].getType());
        Feature_Test.assertEquals((String)"optLang3Type", (String)dataObjectLangs.toArray(new Element[0])[0].getAttribute("type"));
    }

    public void testSetOptionalLanguageSets() {
        Language langSetLang1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("langSetLang5");
        Language langSetLang2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("langSetLang6");
        LanguageSet langSet1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguageSet((Collection<Language>)Arrays.asList(langSetLang1, langSetLang2));
        this.feature.setOptionalLanguageSets((Collection<LanguageSet>)Arrays.asList(langSet1));
        Collection<LanguageSet> langSets = this.feature.getOptionalLanguageSets();
        Collection<Element> dataObjectLangSets = this.session.getChildren(this.session.getChild(this.session.getChild(this.element, "Languages"), "Optional"), "LanguageSet");
        Feature_Test.assertEquals((int)1, (int)langSets.size());
        Feature_Test.assertEquals((int)1, (int)dataObjectLangSets.size());
        Feature_Test.assertEquals((String)"langSetLang5", (String)langSets.toArray(new LanguageSet[0])[0].getLanguages().toArray(new Language[0])[0].getType());
        Feature_Test.assertEquals((String)"langSetLang6", (String)langSets.toArray(new LanguageSet[0])[0].getLanguages().toArray(new Language[0])[1].getType());
        Feature_Test.assertEquals((String)"langSetLang5", (String)this.session.getChildren(dataObjectLangSets.toArray(new Element[0])[0], "Language").toArray(new Element[0])[0].getAttribute("type"));
        Feature_Test.assertEquals((String)"langSetLang6", (String)this.session.getChildren(dataObjectLangSets.toArray(new Element[0])[0], "Language").toArray(new Element[0])[1].getAttribute("type"));
    }

    public void testSetCondition() {
        Condition condition = SPISession.DEFAULT_INSTANCE.createConditionFactory().createCondition();
        condition.setDescription(new TranslatableString("differentDesc", "differentDescKey"));
        this.feature.setCondition(condition);
        Feature_Test.assertEquals((String)"differentDesc", (String)this.feature.getCondition().getDescription().getValue());
        Feature_Test.assertEquals((String)"differentDescKey", (String)this.feature.getCondition().getDescription().getTranslationKey());
        Feature_Test.assertEquals((String)"differentDesc", (String)this.session.getChild(this.session.getChild(this.element, "Condition"), "Description").getTextContent());
        Feature_Test.assertEquals((String)"differentDescKey", (String)this.session.getChild(this.session.getChild(this.element, "Condition"), "Description").getAttribute("translationKey"));
    }

    public void testSetContentElements() {
        this.feature.setContentElements((Collection<String>)Arrays.asList("content3"));
        Feature_Test.assertEquals((int)1, (int)this.feature.getContentElements().size());
        Feature_Test.assertEquals((String)"content3", (String)this.feature.getContentElements().toArray(new String[0])[0]);
        Feature_Test.assertEquals((int)1, (int)this.session.getChildren(this.element, "ContentElement").size());
        Feature_Test.assertEquals((String)"content3", (String)this.session.getChildren(this.element, "ContentElement").toArray(new Element[0])[0].getAttribute("contentElementRef"));
    }

    public void testSetMultiplicity() {
        Multiplicity multi = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createMultiplicity(Boolean.FALSE);
        this.feature.setMultiplicity(multi);
        Feature_Test.assertFalse((boolean)this.feature.getMultiplicity().getMultiplesAllowed());
        Feature_Test.assertFalse((boolean)Boolean.parseBoolean(this.session.getChildren(this.element, "Multiplicity").toArray(new Element[0])[0].getAttribute("multiplesAllowed")));
    }

    public void testSetFeatureID() {
        this.feature.setFeatureID("differentID");
        Feature_Test.assertEquals((String)"differentID", (String)this.feature.getFeatureID());
        Feature_Test.assertEquals((String)"differentID", (String)this.element.getAttribute("id"));
    }

    public void testSetNestedFeatures() {
        DerivedVariable var1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createDerivedVariable("var3ID", "var3Expression");
        NestedFeature feature1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createNestedFeatureWithDerivedVariables("nestedFeature3ID", (Collection<DerivedVariable>)Arrays.asList(var1));
        this.feature.setNestedFeatures((Collection<NestedFeature>)Arrays.asList(feature1));
        Feature_Test.assertEquals((int)1, (int)this.feature.getNestedFeatures().size());
        Feature_Test.assertEquals((int)1, (int)this.session.getChildren(this.element, "NestedFeature").size());
        Feature_Test.assertEquals((String)"nestedFeature3ID", (String)this.feature.getNestedFeatures().toArray(new NestedFeature[0])[0].getFeatureID());
        Feature_Test.assertEquals((String)"nestedFeature3ID", (String)this.session.getChildren(this.element, "NestedFeature").toArray(new Element[0])[0].getAttribute("id"));
    }

    public void testSetRequiredFeature() {
        this.feature.setRequiredFeature((Collection<String>)Arrays.asList("feature3"));
        Feature_Test.assertEquals((int)1, (int)this.feature.getRequiredFeature().size());
        Feature_Test.assertEquals((String)"feature3", (String)this.feature.getRequiredFeature().toArray(new String[0])[0]);
        Feature_Test.assertEquals((int)1, (int)this.session.getChildren(this.element, "RequiredFeature").size());
        Feature_Test.assertEquals((String)"feature3", (String)this.session.getChildren(this.element, "RequiredFeature").toArray(new Element[0])[0].getAttribute("featureRef"));
    }

    public void testSetPackageFeatureReferences() {
        PackageFeatureReference featureRef1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createPackageFeatureReference("contentRef1", "featureRef1");
        this.feature.setPackageFeatureReferences((Collection<PackageFeatureReference>)Arrays.asList(featureRef1));
        Feature_Test.assertEquals((int)1, (int)this.feature.getPackageFeatureReferences().size());
        Feature_Test.assertEquals((String)"contentRef1", (String)this.feature.getPackageFeatureReferences().toArray(new PackageFeatureReference[0])[0].getContentElementRef());
        Feature_Test.assertEquals((String)"featureRef1", (String)this.feature.getPackageFeatureReferences().toArray(new PackageFeatureReference[0])[0].getPackageFeatureRef());
        Feature_Test.assertEquals((int)1, (int)this.session.getChildren(this.element, "PackageFeatureReference").size());
        Feature_Test.assertEquals((String)"contentRef1", (String)this.session.getChildren(this.element, "PackageFeatureReference").toArray(new Element[0])[0].getAttribute("contentElementRef"));
        Feature_Test.assertEquals((String)"featureRef1", (String)this.session.getChildren(this.element, "PackageFeatureReference").toArray(new Element[0])[0].getAttribute("packageFeatureRef"));
    }

    public void testSetVariables() {
        DerivedVariable var1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createVariable("var3ID", "var3Expression");
        this.feature.setVariables((Collection<DerivedVariable>)Arrays.asList(var1));
        Feature_Test.assertEquals((int)1, (int)this.feature.getVariables().size());
        Feature_Test.assertEquals((String)"var3ID", (String)this.feature.getVariables().toArray(new DerivedVariable[0])[0].getVariableID());
        Feature_Test.assertEquals((String)"var3Expression", (String)this.feature.getVariables().toArray(new DerivedVariable[0])[0].getExpression());
        Feature_Test.assertEquals((int)1, (int)this.session.getChildren(this.element, "Variable").size());
        Feature_Test.assertEquals((String)"var3ID", (String)this.session.getChildren(this.element, "Variable").toArray(new Element[0])[0].getAttribute("id"));
        Feature_Test.assertEquals((String)"var3Expression", (String)this.session.getChildren(this.session.getChildren(this.element, "Variable").toArray(new Element[0])[0], "Expression").toArray(new Element[0])[0].getTextContent());
    }

    public void testSetAddOn() {
        this.feature.setAddOn(Boolean.FALSE);
        Feature_Test.assertFalse((boolean)this.feature.getAddOn());
        Feature_Test.assertFalse((boolean)Boolean.parseBoolean(this.element.getAttribute("addOn")));
    }

    public void testSetDisplayName() {
        this.feature.setDisplayName(new TranslatableString("differentName", "differentNameKey"));
        Feature_Test.assertEquals((String)"differentName", (String)this.feature.getDisplayName().getValue());
        Feature_Test.assertEquals((String)"differentNameKey", (String)this.feature.getDisplayName().getTranslationKey());
        Feature_Test.assertEquals((String)"differentName", (String)this.session.getChildren(this.element, "DisplayName").toArray(new Element[0])[0].getTextContent());
        Feature_Test.assertEquals((String)"differentNameKey", (String)this.session.getChildren(this.element, "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetDescription() {
        this.feature.setDescription(new TranslatableString("differentDesc", "differentDescKey"));
        Feature_Test.assertEquals((String)"differentDesc", (String)this.feature.getDescription().getValue());
        Feature_Test.assertEquals((String)"differentDescKey", (String)this.feature.getDescription().getTranslationKey());
        Feature_Test.assertEquals((String)"differentDesc", (String)this.session.getChildren(this.element, "Description").toArray(new Element[0])[0].getTextContent());
        Feature_Test.assertEquals((String)"differentDescKey", (String)this.session.getChildren(this.element, "Description").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetShortDescription() {
        this.feature.setShortDescription(new TranslatableString("differentShortDesc", "differentShortDescKey"));
        Feature_Test.assertEquals((String)"differentShortDesc", (String)this.feature.getShortDescription().getValue());
        Feature_Test.assertEquals((String)"differentShortDescKey", (String)this.feature.getShortDescription().getTranslationKey());
        Feature_Test.assertEquals((String)"differentShortDesc", (String)this.session.getChildren(this.element, "ShortDescription").toArray(new Element[0])[0].getTextContent());
        Feature_Test.assertEquals((String)"differentShortDescKey", (String)this.session.getChildren(this.element, "ShortDescription").toArray(new Element[0])[0].getAttribute("translationKey"));
    }
}

