/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.AlternativeRequirement;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.RequirementResourceConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.RequirementResourceConstraintType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlternativeRequirementType {
    public static Collection<AlternativeRequirement> merge(Collection<AlternativeRequirement> alternativeRequirements1, Collection<AlternativeRequirement> alternativeRequirements2) {
        ArrayList<AlternativeRequirement> alternativeRequirementsToRemove = new ArrayList<AlternativeRequirement>();
        for (AlternativeRequirement alternativeRequirement1 : alternativeRequirements1) {
            for (AlternativeRequirement alternativeRequirement2 : alternativeRequirements2) {
                if (alternativeRequirementsToRemove.contains(alternativeRequirement2) || !AlternativeRequirementType.equals(alternativeRequirement1, alternativeRequirement2)) continue;
                alternativeRequirementsToRemove.add(alternativeRequirement2);
                alternativeRequirement1 = AlternativeRequirementType.merge(alternativeRequirement1, alternativeRequirement2);
            }
        }
        alternativeRequirements2.removeAll(alternativeRequirementsToRemove);
        ArrayList<AlternativeRequirement> finalAlternativeRequirements = new ArrayList<AlternativeRequirement>();
        finalAlternativeRequirements.addAll(alternativeRequirements1);
        finalAlternativeRequirements.addAll(alternativeRequirements2);
        return finalAlternativeRequirements;
    }

    public static AlternativeRequirement merge(AlternativeRequirement requirement1, AlternativeRequirement requirement2) {
        BigInteger priority = BigInteger.ZERO;
        if (requirement1.getPriority() == null) {
            if (requirement2.getPriority() != null) {
                requirement1.setPriority(requirement2.getPriority());
            } else if (requirement1.getPriority() != null && requirement2.getPriority() != null) {
                priority = requirement1.getPriority().compareTo(requirement2.getPriority()) < 0 ? requirement2.getPriority() : requirement1.getPriority();
            }
        }
        if (requirement1.getDescription() == null) {
            if (requirement2.getDescription() != null) {
                requirement1.setDescription(requirement2.getDescription());
            }
        } else if (requirement2.getDescription() != null) {
            TranslatableString description = requirement1.getDescription();
            description.setTranslationKey(String.valueOf(description.getTranslationKey()) + requirement2.getDescription().getTranslationKey());
            description.setTranslationKey(String.valueOf(description.getValue()) + requirement2.getDescription().getValue());
            requirement1.setDescription(description);
        }
        if (requirement1.getDisplayName() == null) {
            if (requirement2.getDisplayName() != null) {
                requirement1.setDisplayName(requirement2.getDisplayName());
            }
        } else if (requirement2.getDescription() != null) {
            TranslatableString value = requirement1.getDisplayName();
            System.out.println(value);
            value.setTranslationKey(String.valueOf(value.getTranslationKey()) + requirement2.getDisplayName().getTranslationKey());
            value.setTranslationKey(String.valueOf(value.getValue()) + requirement2.getDisplayName().getValue());
            requirement1.setDisplayName(value);
        }
        requirement1.setPriority(priority);
        return requirement1;
    }

    public static boolean equals(AlternativeRequirement requirement1, AlternativeRequirement requirement2) {
        if (requirement1.getResourceConstraints().size() != requirement2.getResourceConstraints().size()) {
            return false;
        }
        Iterator constraintIter1 = requirement1.getResourceConstraints().iterator();
        while (constraintIter1.hasNext()) {
            Iterator constraintIter2 = requirement2.getResourceConstraints().iterator();
            RequirementResourceConstraint constraint1 = (RequirementResourceConstraint)constraintIter1.next();
            boolean foundEquals = false;
            while (!foundEquals && constraintIter2.hasNext()) {
                if (!RequirementResourceConstraintType.equals(constraint1, (RequirementResourceConstraint)constraintIter2.next())) continue;
                foundEquals = true;
            }
            if (foundEquals) continue;
            return false;
        }
        return true;
    }
}

