/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.examples.common.spi;


import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public class ForwardingHandler extends StreamHandler
{
	private final Logger forwardingTarget;
	
	public ForwardingHandler(Logger forwardingTarget)
	{
		this.forwardingTarget = forwardingTarget;
	}
	
	public void publish (LogRecord record)
	{
		forwardingTarget.log(record);
	}
}
