/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.xmldsig;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;

/**
 * DigestMethod is a required element that identifies the digest algorithm to 
 * be applied to the signed object.
 * 
 * ds:digestMethod and ds:digestValue MAY be used to digitally sign individual 
 * files. If files are signed, the digest value MUST be calculated over the whole of each file.
 *
 */
public interface DigestMethod {
	/**
	 * Gets the algorithm.
	 * 
	 * @return The algorithm.
	 */
	String getAlgorithm();
	
	/**
	 * Sets the algorithm.
	 * 
	 * @param newAlgorithm The new algorithm.
	 * @throws InvalidInputException if the parameter is null
	 */
	void setAlgorithm(String newAlgorithm);
}
