/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.xmldsig;

/**
 * 
 * The structure of SignedInfo includes the canonicalization algorithm, a signature algorithm, 
 * and one or more references. The SignedInfo element may contain an optional ID attribute that 
 * will allow it to be referenced by other signatures and objects.
 * 
 * SignedInfo does not include explicit signature or digest properties (such as calculation time, 
 * cryptographic device serial number, etc.). If an application needs to associate properties 
 * with the signature or digest, it may include such information in a SignatureProperties element 
 * within an Object element.

 *
 */
public interface SignedInfo {
	/**
	 * Gets the CanonicalizationMethod.
	 * 
	 * @return CanonicalizationMethod.
	 */
	CanonicalizationMethod getCanonicalizationMethod();
	
	/**
	 * Sets the CanonicalizationMethod.
	 * 
	 * @param canonicalizationMethod A new CanonicalizationMethod.
	 */
	void setCanonicalizationMethod(CanonicalizationMethod canonicalizationMethod);
	
	/**
	 * Gets the SignatureMethod.
	 * 
	 * @return SignatureMethod.
	 */
	SignatureMethod getSignatureMethod();
	
	/**
	 * Sets the SignatureMethod.
	 * 
	 * @param signatureMethod A new SignatureMethod.
	 */
	void setSignatureMethod(SignatureMethod signatureMethod);
	
	/**
	 * Gets the Reference.
	 * 
	 * @return Reference.
	 */
	Reference getReference();
	
	/**
	 * Sets the Reference.
	 * 
	 * @param reference A new Reference.
	 */
	void setReference(Reference reference);
}
