/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.internal.dr.drs.service.handler.common;

import java.io.File;
import java.io.PrintWriter;
import java.util.UUID;

import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.AbstractOutputter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IOutputterContext;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IParameters;
import org.eclipse.cosmos.provisional.dr.ps.common.IConstants;

public class QuerySaver extends AbstractOutputter {
	public static final String CMDBF_QUERY="query"; //$NON-NLS-1$
	public static final String PARENTCLASS="parentClass"; //$NON-NLS-1$
	public static final String QUERYCLASS="queryClass"; //$NON-NLS-1$
	public static final String TITLE="title"; //$NON-NLS-1$
	public static final String UUIDPARAM="uuid"; //$NON-NLS-1$
	public static final String FUNC="func"; //$NON-NLS-1$
	public static final String ISFOLDER="folder"; //$NON-NLS-1$
	public static final String RENAME_FUNC="rename"; //$NON-NLS-1$
	public static final String DELETE_FUNC="delete"; //$NON-NLS-1$
	protected String rootDir = ""; //$NON-NLS-1$
	protected boolean autoSave = false;
	
	public void initalize(IOutputterContext context, IParameters parameters) throws Exception {
		this.rootDir = context.getRealPath(IConstants.QUERYREPO+File.separator+IConstants.QUERYDIR);		
		String autoSaveStr = context.getInitParameter("QUERY_SAVE"); //$NON-NLS-1$
		if (autoSaveStr != null)
			autoSave = Boolean.parseBoolean(autoSaveStr);
		super.initalize(context, parameters);
	}
	
	public void render(PrintWriter output, IParameters input) throws Exception {
		String query = input.getParameter(CMDBF_QUERY);
		UUID uuidObj = UUID.randomUUID();
		String uuid = uuidObj.toString(); 
		String title = input.getParameter(TITLE);
		String nodeClass = input.getParameter(QUERYCLASS);
		String parentClass = input.getParameter(PARENTCLASS);
		String func = input.getParameter(FUNC);
		boolean isFolder = ("true".equals((input.getParameter(ISFOLDER)))); //$NON-NLS-1$
		if (RENAME_FUNC.equals(func)){
			uuid = input.getParameter(UUIDPARAM);
			SaverHelper.renameQuery(uuid, title, nodeClass, parentClass, this.rootDir, isFolder);
		}
		else if (DELETE_FUNC.equals(func)){
			if (autoSave){
				uuid = input.getParameter(UUIDPARAM);
				SaverHelper.deleteQuery(uuid, parentClass, this.rootDir);				
			}
		}
		else if (autoSave)
			SaverHelper.saveQuery(query, uuid, title, nodeClass, parentClass, this.rootDir, isFolder);
		
		output.write(uuid);
	}
	
}
