/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.provisional.datamanager;

import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.Set;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.eclipse.cosmos.dc.provisional.datamanager.ConfigurationManager;

public class DataManager {
    public static final String DATA_MANAGER_NAMESPACE = "http://www.eclipse.org/cosmos/datamanager";

    public OMElement getDataManagerInfo(OMElement input) throws Exception {
        ConfigurationManager m = this.DoProp();
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace(DATA_MANAGER_NAMESPACE, "ns");
        OMElement method = fac.createOMElement("getDataManagerInfoResponse", omNs);
        this.Add("id", m.getId(), method, fac, omNs);
        this.Add("name", m.getDisplayName(), method, fac, omNs);
        this.Add("description", m.getDescription(), method, fac, omNs);
        this.Add("soapNamespace", m.getSoapNamespace(), method, fac, omNs);
        this.Add("recordTypeNamespace", m.getRecordTypeNamespace(), method, fac, omNs);
        this.Add("securityNamespace", m.getSecurityNamespace(), method, fac, omNs);
        Properties p = m.getOtherProperties();
        Set<Object> ks = p.keySet();
        Object[] o = ks.toArray();
        int i = 0;
        i = 0;
        while (i < o.length) {
            String tstr = o[i].toString();
            String pstr = p.getProperty(tstr);
            OMElement value = fac.createOMElement("property", omNs);
            value.addChild((OMNode)fac.createOMText((OMContainer)value, tstr));
            method.addChild((OMNode)value);
            OMElement v2 = fac.createOMElement("value", omNs);
            v2.addChild((OMNode)fac.createOMText((OMContainer)v2, pstr));
            method.addChild((OMNode)v2);
            ++i;
        }
        return method;
    }

    public OMElement getSoapVersion(OMElement input) throws Exception {
        ConfigurationManager m = this.DoProp();
        String sns = m.getSoapNamespace();
        String s11 = "http://schemas.xmlsoap.org/soap/envelope/";
        String s12 = "http://www.w3.org/2003/05/soap-envelope";
        String rns = null;
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace(DATA_MANAGER_NAMESPACE, "ns");
        OMElement method = fac.createOMElement("getSoapVersionResponse", omNs);
        if (sns.equals(s11)) {
            rns = new String("1.1");
        }
        if (sns.equals(s12)) {
            rns = new String("1.2");
        }
        if (rns == null) {
            rns = new String("unknown");
        }
        this.Add("version", rns, method, fac, omNs);
        return method;
    }

    private void Add(String label, String str, OMElement method, OMFactory fac, OMNamespace omNs) {
        OMElement Value = fac.createOMElement(label, omNs);
        Value.addChild((OMNode)fac.createOMText((OMContainer)Value, str));
        method.addChild((OMNode)Value);
    }

    private ConfigurationManager DoProp() throws Exception {
        ConfigurationManager ret = null;
        URL resource = this.getClass().getClassLoader().getResource("META-INF/cosmos.properties");
        InputStream in = resource.openStream();
        ret = new ConfigurationManager();
        ret.Init(in);
        return ret;
    }
}

