/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ReferencedPackage;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.ContentSelectionFeatureType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.ContentType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.LanguageType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.OutputVariableType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.RequirementType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.ResourceMapType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.ResultingChangeMapType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.ResultingResourceMapType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.StringType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferencedPackageType {
    public static Collection<ReferencedPackage> merge(Collection<ReferencedPackage> referencedPackages1, Collection<ReferencedPackage> referencedPackages2) {
        ArrayList<ReferencedPackage> referencedPackagesToRemove = new ArrayList<ReferencedPackage>();
        for (ReferencedPackage referencedPackage1 : referencedPackages1) {
            for (ReferencedPackage referencedPackage2 : referencedPackages2) {
                if (referencedPackagesToRemove.contains(referencedPackage2) || !ReferencedPackageType.equals(referencedPackage1, referencedPackage2)) continue;
                referencedPackagesToRemove.add(referencedPackage2);
                referencedPackage1 = ReferencedPackageType.merge(referencedPackage1, referencedPackage2);
            }
        }
        referencedPackages2.removeAll(referencedPackagesToRemove);
        ArrayList<ReferencedPackage> finalReferencedPackages = new ArrayList<ReferencedPackage>();
        finalReferencedPackages.addAll(referencedPackages1);
        finalReferencedPackages.addAll(referencedPackages2);
        return finalReferencedPackages;
    }

    private static ReferencedPackage merge(ReferencedPackage referencedPackage1, ReferencedPackage referencedPackage2) {
        if (referencedPackage1.getWeight() == null && referencedPackage2.getWeight() != null) {
            referencedPackage1.setWeight(referencedPackage2.getWeight());
        }
        if (referencedPackage1.getWeight() != null && referencedPackage2.getWeight() != null && referencedPackage1.getWeight().compareTo(referencedPackage2.getWeight()) < 0) {
            referencedPackage1.setWeight(referencedPackage2.getWeight());
        }
        referencedPackage1.setRequiredFeatures(ContentSelectionFeatureType.merge(referencedPackage1.getRequiredFeatures(), referencedPackage2.getRequiredFeatures()));
        referencedPackage1.setOutputVariables(OutputVariableType.merge(referencedPackage1.getOutputVariables(), referencedPackage2.getOutputVariables()));
        referencedPackage1.setRequirements(RequirementType.merge(referencedPackage1.getRequirements(), referencedPackage2.getRequirements()));
        referencedPackage1.setResultingResourceMaps(ResultingResourceMapType.merge(referencedPackage1.getResultingResourceMaps(), referencedPackage2.getResultingResourceMaps()));
        referencedPackage1.setResultingChangeMaps(ResultingChangeMapType.merge(referencedPackage1.getResultingChangeMaps(), referencedPackage2.getResultingChangeMaps()));
        referencedPackage1.setRequiredResourceMaps(ResourceMapType.merge(referencedPackage1.getRequiredResourceMaps(), referencedPackage2.getRequiredResourceMaps()));
        referencedPackage1.setLanguages(LanguageType.merge(referencedPackage1.getLanguages(), referencedPackage2.getLanguages()));
        return referencedPackage1;
    }

    public static boolean equals(ReferencedPackage rp1, ReferencedPackage rp2) {
        if (ContentType.equals(Util.resolveContentRef(rp1.getContentReference()), Util.resolveContentRef(rp2.getContentReference()))) {
            if (rp1.getOperation() == null && rp2.getOperation() != null) {
                return false;
            }
            if (rp1.getOperation() != null && rp2.getOperation() == null) {
                return false;
            }
            if (rp1.getOperation() != null && rp2.getOperation() != null) {
                return StringType.equals(rp1.getOperation(), rp2.getOperation());
            }
            return true;
        }
        return false;
    }
}

