/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition;

import java.util.Collection;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition.AlternativeConditionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition.ConditionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition.ConditionalPropertyConstraintImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition.ConditionalResourceConstraintImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition.VersionRangeImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition.VersionValueImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.AlternativeCondition;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.Condition;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.ConditionFactory;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.ConditionalPropertyConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.ConditionalResourceConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.VersionRange;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.VersionValue;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionFactoryImpl
implements ConditionFactory {
    private SPISessionImpl session;
    private static final String PROPERTY_VALUE_LIST_TYPE = "sdd-dd:PropertyValueListType";
    private static final String CONDITIONAL_PROPERTY_CONSTRAINT_TYPE = "sdd-dd:ConditionalPropertyConstraintType";
    private static final String VERSION_VALUE_TYPE = "sdd-dd:VersionValueType";

    public ConditionFactoryImpl(SPISessionImpl session) {
        this.session = session;
    }

    @Override
    public AlternativeCondition createAlternativeCondition(String alternativeConditionID) {
        this.session.testParameter(alternativeConditionID, 1, null);
        Element alternativeConditionElement = this.session.createDeploymentElement("Alternative");
        alternativeConditionElement.setAttribute("id", alternativeConditionID);
        return new AlternativeConditionImpl(alternativeConditionElement, this.session);
    }

    @Override
    public Condition createCondition() {
        Element conditionElement = this.session.createDeploymentElement("Condition");
        return new ConditionImpl(conditionElement, this.session);
    }

    @Override
    public ConditionalPropertyConstraint createConditionalPropertyConstraintMultiValue(String propertyName, Collection<String> propertyValues) {
        this.session.testParameter(propertyName, 1, null);
        this.session.testParameter(propertyValues, 2, null);
        Element propertyValueListElement = this.session.createDeploymentElement("ListOfValues");
        for (String propertyValue : propertyValues) {
            Element valueElement = this.session.createDeploymentElement("Value");
            valueElement.setTextContent(propertyValue);
            this.session.insertNode((Node)propertyValueListElement, (Node)valueElement, PROPERTY_VALUE_LIST_TYPE);
        }
        Element propertyNameElement = this.session.createDeploymentElement("PropertyName");
        propertyNameElement.setTextContent(propertyName);
        Element cpcElement = this.session.createDeploymentElement("PropertyConstraint");
        this.session.insertNode((Node)cpcElement, (Node)propertyNameElement, CONDITIONAL_PROPERTY_CONSTRAINT_TYPE);
        this.session.insertNode((Node)cpcElement, (Node)propertyValueListElement, CONDITIONAL_PROPERTY_CONSTRAINT_TYPE);
        return new ConditionalPropertyConstraintImpl(cpcElement, this.session);
    }

    @Override
    public ConditionalPropertyConstraint createConditionalPropertyConstraintSingleValue(String propertyName, String value) {
        this.session.testParameter(propertyName, 1, null);
        this.session.testParameter(value, 2, null);
        Element propertyNameElement = this.session.createDeploymentElement("PropertyName");
        propertyNameElement.setTextContent(propertyName);
        Element valueElement = this.session.createDeploymentElement("Value");
        valueElement.setTextContent(value);
        Element cpcElement = this.session.createDeploymentElement("PropertyConstraint");
        this.session.insertNode((Node)cpcElement, (Node)propertyNameElement, CONDITIONAL_PROPERTY_CONSTRAINT_TYPE);
        this.session.insertNode((Node)cpcElement, (Node)valueElement, CONDITIONAL_PROPERTY_CONSTRAINT_TYPE);
        return new ConditionalPropertyConstraintImpl(cpcElement, this.session);
    }

    @Override
    public ConditionalResourceConstraint createConditionalResourceConstraint(String constraintID, String resourceReference) {
        this.session.testParameter(constraintID, 1, null);
        this.session.testParameter(resourceReference, 2, null);
        Element crcElement = this.session.createDeploymentElement("ResourceConstraint");
        crcElement.setAttribute("resourceRef", resourceReference);
        crcElement.setAttribute("id", constraintID);
        return new ConditionalResourceConstraintImpl(crcElement, this.session);
    }

    @Override
    public VersionRange createVersionRange() {
        Element versionRangeElement = this.session.createDeploymentElement("Range");
        return new VersionRangeImpl(versionRangeElement, this.session);
    }

    @Override
    public VersionValue createVersionValue(String version) {
        this.session.testParameter(version, 1, null);
        Element versionElement = this.session.createDeploymentElement("Version");
        versionElement.setTextContent(version);
        Element versionValueElement = this.session.createDeploymentElement("Value");
        this.session.insertNode((Node)versionValueElement, (Node)versionElement, VERSION_VALUE_TYPE);
        return new VersionValueImpl(versionValueElement, this.session);
    }
}

