/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.ConstrainedResourceImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ConstrainedResource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Multiplicity;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiplicityImpl
extends SPIDataObject
implements Multiplicity {
    private static final String MULTIPLICITY_TYPE = "sdd-dd:MultiplicityType";

    public MultiplicityImpl(Element data, SPISessionImpl session) {
        super(data, session, MULTIPLICITY_TYPE);
    }

    @Override
    public Collection<String> getConstrainedFeatures() {
        ArrayList<String> constrainedFeatures = new ArrayList<String>();
        Collection<Element> constrainedFeatureElements = this.getChildren("ConstrainedFeature");
        for (Element constrainedFeatureElement : constrainedFeatureElements) {
            String featureRef = constrainedFeatureElement.getAttribute("featureRef");
            constrainedFeatures.add(featureRef);
        }
        return constrainedFeatures;
    }

    @Override
    public Collection<ConstrainedResource> getConstrainedResources() {
        ArrayList<ConstrainedResource> constrainedResources = new ArrayList<ConstrainedResource>();
        Collection<Element> constrainedResourceElements = this.getChildren("ConstrainedResource");
        for (Element constrainedResourceElement : constrainedResourceElements) {
            ConstrainedResourceImpl constrainedResource = new ConstrainedResourceImpl(constrainedResourceElement, this.session);
            constrainedResources.add(constrainedResource);
        }
        return constrainedResources;
    }

    @Override
    public BigInteger getMaxSelections() {
        BigInteger maxSelections = null;
        if (this.isSetAttribute("maxSelections")) {
            maxSelections = new BigInteger(this.getAttribute("maxSelections"));
        }
        return maxSelections;
    }

    @Override
    public BigInteger getMinSelections() {
        BigInteger minSelections = null;
        if (this.isSetAttribute("minSelections")) {
            minSelections = new BigInteger(this.getAttribute("minSelections"));
        }
        return minSelections;
    }

    @Override
    public Boolean getMultiplesAllowed() {
        Boolean multiplesAllowed = null;
        if (this.isSetAttribute("multiplesAllowed")) {
            multiplesAllowed = Boolean.parseBoolean(this.getAttribute("multiplesAllowed"));
        }
        return multiplesAllowed;
    }

    @Override
    public void setConstrainedFeatures(Collection<String> constrainedFeatureSelections) {
        if (constrainedFeatureSelections == null) {
            this.unSetElement("ConstrainedFeature");
        } else {
            ArrayList<Element> constrainedFeatureElements = new ArrayList<Element>();
            this.removeContent(this.getChildren("ConstrainedFeature", false));
            for (String constrainedFeature : constrainedFeatureSelections) {
                Element constrainedFeatureElement = this.session.createDeploymentElement("ConstrainedFeature");
                constrainedFeatureElement.setAttribute("featureRef", constrainedFeature);
                constrainedFeatureElements.add(constrainedFeatureElement);
            }
            this.addContent(constrainedFeatureElements);
        }
    }

    @Override
    public void setConstrainedResources(Collection<ConstrainedResource> constrainedResourceInstances) {
        if (constrainedResourceInstances == null) {
            this.unSetElement("ConstrainedResource");
        } else {
            this.removeContent(this.getChildren("ConstrainedResource", false));
            this.addContent(constrainedResourceInstances);
        }
    }

    @Override
    public void setMaxSelections(BigInteger maxSelections) {
        if (maxSelections == null) {
            this.unSetAttribute("maxSelections");
        } else {
            this.setAttribute("maxSelections", maxSelections.toString());
        }
    }

    @Override
    public void setMinSelections(BigInteger minSelections) {
        if (minSelections == null) {
            this.unSetAttribute("minSelections");
        } else {
            this.setAttribute("minSelections", minSelections.toString());
        }
    }

    @Override
    public void setMultiplesAllowed(Boolean multiplesAllowed) {
        this.session.testParameter(multiplesAllowed, 1, null);
        if (multiplesAllowed == null) {
            this.unSetAttribute("multiplesAllowed");
        } else {
            this.setAttribute("multiplesAllowed", multiplesAllowed.toString());
        }
    }

    @Override
    public Object clone() {
        return new MultiplicityImpl((Element)this.getElement().cloneNode(true), this.session);
    }
}

