/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ConstrainedResource;
import org.w3c.dom.Element;

public class ConstrainedResourceImpl extends SPIDataObject implements ConstrainedResource {
	private static final String CONSTRAINED_RESOURCE_TYPE = "sdd-dd:ConstrainedResourceType";
    
    public ConstrainedResourceImpl(Element dataObject, SPISessionImpl session) {
        super(dataObject, session, CONSTRAINED_RESOURCE_TYPE);
    }

    public String getConstraintType() {
        return getAttribute("constraintType");
    }

    public String getResourceRef() {
        return getAttribute("resourceRef");
    }

    public void setConstraintType(String type) {
        if (type == null) {
            unSetAttribute("constraintType");
        }
        else {
            setAttribute("constraintType", type);
        }
    }

    public void setResourceRef(String resourceRef) {
    	 if (resourceRef == null) {
             unSetAttribute("resourceRef");
    	 }
         else {
             setAttribute("resourceRef", resourceRef);
         }
    }

    public Object clone() {
    	return new ConstrainedResourceImpl((Element)getElement().cloneNode(true), session);        
    }
}
