/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/

package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition.VersionRangeImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition.VersionValueImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.VersionRange;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.VersionValue;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.VersionConstraintValue;
import org.w3c.dom.Element;

public class VersionConstraintValueImpl extends SPIDataObject implements VersionConstraintValue {
	private static final String VERSION_CONSTRAINT_VALUE_TYPE = "sdd-dd:VersionConstraintValueType";

	public VersionConstraintValueImpl(Element data, SPISessionImpl session) {
		super(data, session, VERSION_CONSTRAINT_VALUE_TYPE);
	}
	
	public Collection<VersionRange> getRanges() {
		Collection<Element> rangeElements = getChildren("Range");
		Collection<VersionRange> ranges = new ArrayList<VersionRange>();
			
		for (Element element : rangeElements) {
			VersionRange vr = new VersionRangeImpl(element, session);
			ranges.add(vr);
		}
			 
		return ranges;
	}

	public Collection<VersionValue> getValues() {
		Collection<Element> valueElements = getChildren("Value");
		Collection<VersionValue> value = new ArrayList<VersionValue>();
			
		for (Element element : valueElements) {
			VersionValue vv = new VersionValueImpl(element, session);
			value.add(vv);
		}
			
		return value;
	}

	public void setRange(Collection<VersionRange> range) {
		if (range != null && !range.isEmpty()) {
            removeContent(getChildren("Range", false));

            addContent(range);
        }
        else {
        	unSetElement("Range");
        }

	}

	public void setValue(Collection<VersionValue> value) {
		if (value != null && !value.isEmpty()) {
            removeContent(getChildren("Value", false));

            addContent(value);
        }
        else {
        	unSetElement("Value");
        }
	}
}