/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;

/**
 * A RequiredBaseFactory is used to create objects representing
 * {@link RequiredBase} elements and associated constraints.
 *
 */
public interface RequiredBaseFactory {
	/**
	 * Creates a new AlternativeRequiredBaseConstraint.
	 * 
	 * @param id Constraint identifier scoped to the deployment descriptor.
	 * @return A new AlternativeRequiredBaseConstraint object.
	 * @throws InvalidInputException if the parameter is null.
	 */
	AlternativeRequiredBaseConstraint createAlternativeRequiredBaseConstraint(String id)
			throws InvalidInputException;
	
	/**
	 * Creates a new RequiredBase.
	 * 
	 * @return a new RequiredBase.
	 */
	RequiredBase createRequiredBase();
	
	/**
	 * Creates a new localization base.
	 * 
	 * @return a new RequiredBase object with element name "LocalizationBase".
	 */
	RequiredBase createLocalizationBase();
	
	/**
	 * Creates a new RequiredBaseConstraint.
	 * 
	 * @param id Constraint identifier scoped to the deployment descriptor.
	 * @param resourceReference Reference to the resource representing the required base for an update operation. 
	 * @return a new RequiredBaseConstraint
	 * @throws InvalidInputException if any of the parameters is null.
	 */
	RequiredBaseConstraint createRequiredBaseConstraint(String id, String resourceReference)
			throws InvalidInputException;
}
