/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable;

import java.util.Collection;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;

/**
 * A ConditionalDerivedVariable defines a series of expressions with optional conditions. The value of the variable is determined by 
 * evaluating the boolean conditions and then setting the variable to the result of the top priority expression from the set of 
 * expressions whose conditions evaluate to true. This restriction does not apply to variables of the same name in different 
 * descriptors. The SDD author MUST create DerivedVariables in a way that makes the selection of the expression unambiguous.<br><br>
 * 
 * Related class {@link DerivedVariable}  
 */
public interface ConditionalDerivedVariable extends BaseVariable {
    /**
     * Gets the conditional derived expressions.
     * 
     * When the variable will take one of a number of possible values depending on the characteristics of the resources that 
     * participate in the particular deployment, then one ConditionalExpression element is defined for each value-condition pair.
     * 
     * @return A collection of expressions and associated conditions.
     */
    Collection<ConditionalDerivedVariableExpression> getConditionalDerivedExpressions();
	
	/**
	 * Sets the conditional derived expressions.
	 * 
	 * When the variable will take one of a number of possible values depending on the characteristics of the resources that 
     * participate in the particular deployment, then one ConditionalExpression element is defined for each value-condition pair.
     * 
	 * @param newExpressions A collection of expressions and associated conditions.
	 * @throws InvalidInputException if the parameter is null
	 */
	void setConditionalDerivedExpressions(
	        Collection<ConditionalDerivedVariableExpression> newExpressions);
	
	/**
	 * Creates a copy of this object.
	 * 
	 * @return A copy of this object. 
	 */
	Object clone();
}
