/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.xmldsig;

/**
 * 
 * The signature element is an enveloped signature over the SDD package. 
 * Note that each Content element included in the package is digitally signed 
 * indirectly via this digest. Files can also be individually signed in the Content element.
 * For details and examples, see {@link http://www.w3.org/TR/xmldsig-core/#sec-Overview}.
 */
public interface Signature {
	/**
	 * Gets the signed information.
	 * 
	 * @return The SignedInfo object.
	 */
	SignedInfo getSignedInfo();
	
	/**
	 * Sets the signed information.
	 * 
	 * @param signedInfo The new SignedInfo object.
	 */
	void setSignedInfo(SignedInfo signedInfo);
	
	/**
	 * Gets the signature value.
	 * 
	 * @return The signature value.
	 */
	byte[] getSignatureValue();
	
	/**
	 * Sets the signature value.
	 * 
	 * @param signatureValue The new signature value.
	 */
	void setSignatureValue(byte[] signatureValue);
	
	/**
	 * Gets the signature value ID.
	 * 
	 * @return The signature value ID.
	 */
	String getSignatureValueId();
	
	/**
	 * Sets the signature value ID.
	 * 
	 * @param id The new signature value ID.
	 */
	void setSignatureValueId(String id);
	
	/**
	 * Gets the key information.
	 * 
	 * @return The key information.
	 */
	KeyInfo getKeyInfo();
	
	/** 
	 * Sets the key information.
	 * 
	 * @param keyInfo The new key information.
	 */
	void setKeyInfo(KeyInfo keyInfo);
	
	/**
	 * Gets the signature object.
	 * 
	 * @return The signature object.
	 */
	SignatureObject getObject();
	
	/**
	 * Sets the signature object.
	 * 
	 * @param object The new signature object.
	 */
	void setObject(SignatureObject object);
	
	/**
	 * Gets the ID.
	 * 
	 * @return The ID.
	 */
	String getId();
	
	/**
	 * Sets the ID.
	 * 
	 * @param id The new ID.
	 */
	void setId(String id);
}
