/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;


public class TranslatableStringType
{
	static TranslatableString merge(TranslatableString description1,	TranslatableString description2)
	{
		if ((description1==null)&&(description2!=null))
			return description2;
		else if (description2!=null)
		{
			description1.setTranslationKey(description1.getTranslationKey()+description2.getTranslationKey());
			description1.setValue(description1.getValue()+description2.getValue());
		}
		return description1;
	}
	static boolean equals(TranslatableString description1,	TranslatableString description2)
	{
		if (description1.getTranslationKey().equals(description2.getTranslationKey()))
			if (description1.getValue().equals(description2.getValue()))
				return true;
		return false;
	}
}