/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/

package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.Collection;
import java.util.Iterator;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.VersionValue;

public class VersionValueType {
	public static boolean equals(VersionValue versionValue1, VersionValue versionValue2){
		if(VersionType.equals(versionValue1.getVersion(), versionValue2.getVersion())){
			Collection<String> fixNames1 = versionValue1.getFixNames();
			Collection<String> fixNames2 = versionValue2.getFixNames();
			
			Iterator<String> fixNamesIter1 = fixNames1.iterator();		
			
			//iterate and make sure both fix name collections are identical
			while (fixNamesIter1.hasNext())
			{
				String fixName = fixNamesIter1.next();
				Iterator<String> fixNamesIter2 = fixNames2.iterator();
				boolean found = false;
				while(fixNamesIter2.hasNext())
				{
					String fixName2 = fixNamesIter2.next();
					
					if ( fixName.equalsIgnoreCase(fixName2) )
					{
						fixNamesIter2.remove();
						found = true;
					}
						
				}
				
				if(!found){
					return false;
				}
			}
			
			if(fixNames2.isEmpty()){
				return true;
			}
			
		}
		return false;
	}

}
